/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.floatcodec;

import io.datarouter.bytes.codec.floatcodec.FloatCodec;

public class RawFloatCodec
implements FloatCodec {
    public static final RawFloatCodec INSTANCE = new RawFloatCodec();
    private static final int LENGTH = 4;

    public int length() {
        return 4;
    }

    @Override
    public byte[] encode(float value) {
        int bits = Float.floatToIntBits(value);
        byte[] out = new byte[]{(byte)(bits >>> 24), (byte)(bits >>> 16), (byte)(bits >>> 8), (byte)bits};
        return out;
    }

    @Override
    public float decode(byte[] bytes, int offset) {
        int bits = (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
        return Float.intBitsToFloat(bits);
    }
}

