/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.floatcodec;

import io.datarouter.bytes.codec.floatcodec.FloatCodec;
import io.datarouter.bytes.codec.intcodec.ComparableIntCodec;

public class ComparableFloatCodec
implements FloatCodec {
    public static final ComparableFloatCodec INSTANCE = new ComparableFloatCodec();
    private static final ComparableIntCodec COMPARABLE_INT_CODEC = ComparableIntCodec.INSTANCE;

    @Override
    public byte[] encode(float value) {
        int intBits = Float.floatToRawIntBits(value);
        if (intBits < 0) {
            intBits ^= Integer.MAX_VALUE;
        }
        return COMPARABLE_INT_CODEC.encode(intBits);
    }

    @Override
    public float decode(byte[] bytes, int offset) {
        int intBits = COMPARABLE_INT_CODEC.decode(bytes, offset);
        if (intBits < 0) {
            intBits ^= Integer.MAX_VALUE;
        }
        return Float.intBitsToFloat(intBits);
    }
}

