/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.doublecodec;

import io.datarouter.bytes.codec.doublecodec.DoubleCodec;
import io.datarouter.bytes.codec.longcodec.RawLongCodec;

public class RawDoubleCodec
implements DoubleCodec {
    public static final RawDoubleCodec INSTANCE = new RawDoubleCodec();
    private static final int LENGTH = 8;
    private static final RawLongCodec RAW_LONG_CODEC = RawLongCodec.INSTANCE;

    public int length() {
        return 8;
    }

    @Override
    public byte[] encode(double value) {
        byte[] bytes = new byte[8];
        this.encode(value, bytes, 0);
        return bytes;
    }

    @Override
    public int encode(double value, byte[] bytes, int offset) {
        long longValue = Double.doubleToLongBits(value);
        RAW_LONG_CODEC.encode(longValue, bytes, offset);
        return 8;
    }

    @Override
    public double decode(byte[] bytes, int offset) {
        long longValue = RAW_LONG_CODEC.decode(bytes, offset);
        return Double.longBitsToDouble(longValue);
    }
}

