/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.doublecodec;

import io.datarouter.bytes.codec.doublecodec.DoubleCodec;
import io.datarouter.bytes.codec.longcodec.ComparableLongCodec;

public class ComparableDoubleCodec
implements DoubleCodec {
    public static final ComparableDoubleCodec INSTANCE = new ComparableDoubleCodec();
    private static final int LENGTH = 8;
    private static final ComparableLongCodec COMPARABLE_LONG_CODEC = ComparableLongCodec.INSTANCE;

    public int length() {
        return 8;
    }

    @Override
    public byte[] encode(double value) {
        byte[] bytes = new byte[8];
        this.encode(value, bytes, 0);
        return bytes;
    }

    @Override
    public int encode(double value, byte[] bytes, int offset) {
        long longValue = Double.doubleToLongBits(value);
        if (longValue < 0L) {
            longValue ^= Long.MAX_VALUE;
        }
        return COMPARABLE_LONG_CODEC.encode(longValue, bytes, offset);
    }

    @Override
    public double decode(byte[] bytes, int offset) {
        long longBits = COMPARABLE_LONG_CODEC.decode(bytes, offset);
        if (longBits < 0L) {
            longBits ^= Long.MAX_VALUE;
        }
        return Double.longBitsToDouble(longBits);
    }
}

