/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.array.longarray;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.longcodec.ComparableLongCodec;

public class ComparableLongArrayCodec {
    public static final ComparableLongArrayCodec INSTANCE = new ComparableLongArrayCodec();
    private static final ComparableLongCodec COMPARABLE_LONG_CODEC = ComparableLongCodec.INSTANCE;
    private static final int LENGTH = COMPARABLE_LONG_CODEC.length();

    public byte[] encode(long[] values) {
        if (values.length == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[LENGTH * values.length];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(long[] values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.length) {
            COMPARABLE_LONG_CODEC.encode(values[i], bytes, cursor);
            cursor += LENGTH;
            ++i;
        }
        return values.length * LENGTH;
    }

    public long[] decode(byte[] bytes) {
        if (bytes == null) {
            return EmptyArray.LONG;
        }
        return this.decode(bytes, 0, bytes.length);
    }

    public long[] decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return EmptyArray.LONG;
        }
        if (bytesLength % LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + LENGTH);
        }
        int resultLength = bytesLength / LENGTH;
        long[] result = new long[resultLength];
        int cursor = offset;
        int i = 0;
        while (i < resultLength) {
            result[i] = COMPARABLE_LONG_CODEC.decode(bytes, cursor);
            cursor += LENGTH;
            ++i;
        }
        return result;
    }
}

