/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.array.intarray;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.intcodec.ComparableIntCodec;

public class ComparableIntArrayCodec {
    public static final ComparableIntArrayCodec INSTANCE = new ComparableIntArrayCodec();
    private static final ComparableIntCodec COMPARABLE_INT_CODEC = ComparableIntCodec.INSTANCE;
    private static final int LENGTH = COMPARABLE_INT_CODEC.length();

    public byte[] encode(int[] values) {
        if (values.length == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[LENGTH * values.length];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(int[] values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.length) {
            COMPARABLE_INT_CODEC.encode(values[i], bytes, cursor);
            cursor += LENGTH;
            ++i;
        }
        return values.length * LENGTH;
    }

    public int[] decode(byte[] bytes) {
        if (bytes == null) {
            return EmptyArray.INT;
        }
        return this.decode(bytes, 0, bytes.length);
    }

    public int[] decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return EmptyArray.INT;
        }
        if (bytesLength % LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + LENGTH);
        }
        int resultLength = bytesLength / LENGTH;
        int[] result = new int[resultLength];
        int cursor = offset;
        int i = 0;
        while (i < resultLength) {
            result[i] = COMPARABLE_INT_CODEC.decode(bytes, cursor);
            cursor += LENGTH;
            ++i;
        }
        return result;
    }
}

