/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.VarIntTool;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class StringByteTool {
    private static final int NULL_LENGTH = 0;

    public static byte[] getUtf8Bytes(String str) {
        if (str == null) {
            return null;
        }
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] getNullableStringByteArray(List<String> valuesWithNulls) {
        if (valuesWithNulls == null) {
            throw new RuntimeException("String list cannot be null");
        }
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>(valuesWithNulls.size());
        byteArrays.add(VarIntTool.encode(valuesWithNulls.size()));
        int i = 0;
        while (i < valuesWithNulls.size()) {
            String str = valuesWithNulls.get(i);
            byte[] stringByteValue = str == null ? new byte[]{} : StringByteTool.getUtf8Bytes(str);
            byte[] byteLen = VarIntTool.encode(str == null ? 0 : stringByteValue.length + 1);
            byteArrays.add(ByteTool.concatenate(byteLen, stringByteValue));
            ++i;
        }
        return ByteTool.concatenate(byteArrays);
    }

    public static List<String> fromNullableStringByteArray(byte[] values) {
        int position = 0;
        int listLength = VarIntTool.decodeInt(values, position);
        position += VarIntTool.length(listLength);
        ArrayList<String> strings = new ArrayList<String>(listLength);
        while (position < values.length) {
            int stringLength = VarIntTool.decodeInt(values, position);
            position += VarIntTool.length(stringLength);
            if (stringLength == 0) {
                strings.add(null);
                continue;
            }
            byte[] stringBytes = ByteTool.copyOfRange(values, position, stringLength - 1);
            position += stringBytes.length;
            String string = StringByteTool.fromUtf8Bytes(stringBytes);
            strings.add(string);
        }
        return strings;
    }

    public static int toUtf8Bytes(String str, byte[] destination, int offset) {
        byte[] bytes = StringByteTool.getUtf8Bytes(str);
        System.arraycopy(bytes, 0, destination, offset, bytes.length);
        return bytes.length;
    }

    public static String fromUtf8Bytes(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public static String fromUtf8Bytes(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

