/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.LongArray;
import io.datarouter.bytes.codec.array.longarray.ComparableLongArrayCodec;
import io.datarouter.bytes.codec.longcodec.ComparableLongCodec;
import io.datarouter.bytes.codec.longcodec.RawLongCodec;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongByteTool {
    private static final Logger logger = LoggerFactory.getLogger(LongByteTool.class);
    private static final RawLongCodec RAW_CODEC = RawLongCodec.INSTANCE;
    private static final ComparableLongCodec COMPARABLE_CODEC = ComparableLongCodec.INSTANCE;
    private static final ComparableLongArrayCodec COMPARABLE_ARRAY_CODEC = ComparableLongArrayCodec.INSTANCE;

    public static byte[] getRawBytes(long in) {
        return RAW_CODEC.encode(in);
    }

    public static int toRawBytes(long in, byte[] bytes, int offset) {
        return RAW_CODEC.encode(in, bytes, offset);
    }

    public static long fromRawBytes(byte[] bytes, int byteOffset) {
        return RAW_CODEC.decode(bytes, byteOffset);
    }

    public static byte[] getComparableBytes(long value) {
        return COMPARABLE_CODEC.encode(value);
    }

    public static int toComparableBytes(long value, byte[] bytes, int offset) {
        return COMPARABLE_CODEC.encode(value, bytes, offset);
    }

    public static Long fromComparableBytes(byte[] bytes, int byteOffset) {
        return COMPARABLE_CODEC.decode(bytes, byteOffset);
    }

    public static byte[] getComparableByteArray(long[] values) {
        return COMPARABLE_ARRAY_CODEC.encode(values);
    }

    public static long[] fromComparableByteArray(byte[] bytes) {
        return COMPARABLE_ARRAY_CODEC.decode(bytes);
    }

    public static byte[] getUInt63Bytes(long value) {
        if (value < 0L && value != Long.MIN_VALUE) {
            logger.warn("", (Throwable)new IllegalArgumentException("no negatives: " + value));
        }
        return LongByteTool.getRawBytes(value);
    }

    public static long fromUInt63Bytes(byte[] bytes, int byteOffset) {
        long longValue = LongByteTool.fromRawBytes(bytes, byteOffset);
        if (longValue < 0L && longValue != Long.MIN_VALUE) {
            logger.warn("", (Throwable)new IllegalArgumentException("no negatives: " + longValue));
        }
        return longValue;
    }

    public static byte[] getUInt63ByteArray(List<Long> valuesWithNulls) {
        if (valuesWithNulls == null) {
            return EmptyArray.BYTE;
        }
        LongArray values = valuesWithNulls instanceof LongArray ? (LongArray)valuesWithNulls : new LongArray(valuesWithNulls);
        byte[] out = new byte[8 * values.size()];
        int i = 0;
        while (i < values.size()) {
            System.arraycopy(LongByteTool.getUInt63Bytes(values.getPrimitive(i)), 0, out, i * 8, 8);
            ++i;
        }
        return out;
    }

    public static long[] fromUInt63ByteArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return EmptyArray.LONG;
        }
        return LongByteTool.fromUInt63ByteArray(bytes, 0, bytes.length);
    }

    public static long[] fromUInt63ByteArray(byte[] bytes, int startIdx, int length) {
        long[] out = new long[length / 8];
        int byteOffset = startIdx;
        int i = 0;
        while (i < out.length) {
            out[i] = LongByteTool.fromUInt63Bytes(bytes, byteOffset);
            byteOffset += 8;
            ++i;
        }
        return out;
    }
}

