/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Java9 {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    @SafeVarargs
    public static <T> List<T> listOf(T ... items) {
        int i = 0;
        while (i < items.length) {
            Objects.requireNonNull(items[i]);
            ++i;
        }
        return Collections.unmodifiableList(Arrays.asList(items));
    }

    public static int compareUnsigned(byte[] bytesA, byte[] bytesB) {
        if (bytesA == bytesB) {
            return 0;
        }
        if (bytesA == null || bytesB == null) {
            return bytesA == null ? -1 : 1;
        }
        int lengthA = bytesA.length;
        int lengthB = bytesB.length;
        int i = 0;
        int j = 0;
        while (i < lengthA && j < lengthB) {
            int byteA = bytesA[i] & 0xFF;
            int byteB = bytesB[j] & 0xFF;
            if (byteA != byteB) {
                return byteA - byteB;
            }
            ++i;
            ++j;
        }
        return lengthA - lengthB;
    }

    public static int checkFromIndexSize(int fromIndex, int size, int length) {
        if (fromIndex < 0) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (fromIndex + size > length) {
            throw new IllegalArgumentException("fromIndex + size > length");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        return fromIndex;
    }

    public static int readNBytes(InputStream inputStream, byte[] bytes, int off, int len) throws IOException {
        Java9.checkFromIndexSize(off, len, bytes.length);
        int num = 0;
        while (num < len) {
            int count = inputStream.read(bytes, off + num, len - num);
            if (count < 0) break;
            num += count;
        }
        return num;
    }

    public static long transferTo(InputStream inputStream, OutputStream out) throws IOException {
        int read;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[8192];
        while ((read = inputStream.read(buffer, 0, 8192)) >= 0) {
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }
}

