/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.codec.array.intarray.ComparableIntArrayCodec;
import io.datarouter.bytes.codec.intcodec.ComparableIntCodec;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import io.datarouter.bytes.codec.intcodec.UInt31Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerByteTool {
    private static final Logger logger = LoggerFactory.getLogger(IntegerByteTool.class);
    private static final int NULL = Integer.MIN_VALUE;
    private static final RawIntCodec RAW_CODEC = RawIntCodec.INSTANCE;
    private static final ComparableIntCodec COMPARABLE_CODEC = ComparableIntCodec.INSTANCE;
    private static final ComparableIntArrayCodec COMPARABLE_ARRAY_CODEC = ComparableIntArrayCodec.INSTANCE;
    private static final UInt31Codec U_INT_31_CODEC = UInt31Codec.INSTANCE;

    public static byte[] getRawBytes(int in) {
        return RAW_CODEC.encode(in);
    }

    public static int toRawBytes(int in, byte[] bytes, int offset) {
        return RAW_CODEC.encode(in, bytes, offset);
    }

    public static int fromRawBytes(byte[] bytes, int offset) {
        return RAW_CODEC.decode(bytes, offset);
    }

    private static byte[] getBytesNullable(Integer value) {
        if (value == null) {
            return IntegerByteTool.getComparableBytes(Integer.MIN_VALUE);
        }
        return IntegerByteTool.getComparableBytes(value);
    }

    private static Integer fromBytesNullable(byte[] bytes, int offset) {
        Integer fromBytes = IntegerByteTool.fromComparableBytes(bytes, offset);
        if (fromBytes == Integer.MIN_VALUE) {
            return null;
        }
        return fromBytes;
    }

    public static byte[] getComparableBytes(int value) {
        return COMPARABLE_CODEC.encode(value);
    }

    public static int toComparableBytes(int value, byte[] bytes, int offset) {
        return COMPARABLE_CODEC.encode(value, bytes, offset);
    }

    public static int fromComparableBytes(byte[] bytes, int byteOffset) {
        return COMPARABLE_CODEC.decode(bytes, byteOffset);
    }

    public static List<Integer> fromIntegerByteArray(byte[] bytes, int startIdx) {
        int numIntegers = (bytes.length - startIdx) / 4;
        ArrayList<Integer> integers = new ArrayList<Integer>();
        byte[] arrayToCopy = new byte[4];
        int i = 0;
        while (i < numIntegers) {
            System.arraycopy(bytes, i * 4 + startIdx, arrayToCopy, 0, 4);
            integers.add(IntegerByteTool.fromBytesNullable(arrayToCopy, 0));
            ++i;
        }
        return integers;
    }

    public static byte[] getIntegerByteArray(List<Integer> valuesWithNulls) {
        if (valuesWithNulls == null) {
            return null;
        }
        byte[] out = new byte[4 * valuesWithNulls.size()];
        int i = 0;
        while (i < valuesWithNulls.size()) {
            byte[] bytesNullable = IntegerByteTool.getBytesNullable(valuesWithNulls.get(i));
            logger.debug(Arrays.toString(bytesNullable));
            System.arraycopy(bytesNullable, 0, out, i * 4, 4);
            ++i;
        }
        logger.info(Arrays.toString(out));
        return out;
    }

    public static byte[] getComparableByteArray(int[] values) {
        return COMPARABLE_ARRAY_CODEC.encode(values);
    }

    public static int[] fromComparableByteArray(byte[] bytes) {
        return COMPARABLE_ARRAY_CODEC.decode(bytes);
    }

    public static byte[] getUInt31Bytes(int value) {
        return U_INT_31_CODEC.encode(value);
    }

    public static int fromUInt31Bytes(byte[] bytes, int startIdx) {
        return U_INT_31_CODEC.decode(bytes, startIdx);
    }
}

