/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.Java9;
import io.datarouter.scanner.Scanner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;

public class InputStreamTool {
    public static final long count(InputStream inputStream, int bufferSize) {
        long count = 0L;
        try {
            int numRead;
            byte[] buffer = new byte[bufferSize];
            while ((numRead = inputStream.read(buffer)) != -1) {
                count += (long)numRead;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return count;
    }

    public static final long countByte(InputStream inputStream, int bufferSize, byte matchByte) {
        long count = 0L;
        try {
            int numRead;
            byte[] buffer = new byte[bufferSize];
            while ((numRead = inputStream.read(buffer)) != -1) {
                int i = 0;
                while (i < numRead) {
                    if (buffer[i] == matchByte) {
                        ++count;
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return count;
    }

    public static final byte[] readThroughByte(InputStream inputStream, byte throughByte) {
        int throughInt = Byte.toUnsignedInt(throughByte);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int in;
            do {
                in = inputStream.read();
                result.write(in);
            } while (in != throughInt);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return result.toByteArray();
    }

    public static final byte[] readNBytes(InputStream inputStream, int len) {
        byte[] bytes = new byte[len];
        try {
            int numRead = Java9.readNBytes(inputStream, bytes, 0, len);
            if (numRead == len) {
                return bytes;
            }
            return Arrays.copyOfRange(bytes, 0, numRead);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static final void transferTo(InputStream inputStream, OutputStream outputStream) {
        try {
            Java9.transferTo(inputStream, outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static final Scanner<byte[]> scanChunks(InputStream inputStream, int chunkSize) {
        return Scanner.generate(() -> InputStreamTool.readNBytes(inputStream, chunkSize)).advanceWhile(chunk -> ((byte[])chunk).length > 0);
    }
}

