/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.LongByteTool;
import io.datarouter.bytes.codec.doublecodec.ComparableDoubleCodec;
import io.datarouter.bytes.codec.doublecodec.RawDoubleCodec;
import java.util.ArrayList;
import java.util.List;

public class DoubleByteTool {
    private static final long NaN = 0x10000000000000L;
    private static final RawDoubleCodec RAW_CODEC = RawDoubleCodec.INSTANCE;
    private static final ComparableDoubleCodec COMPARABLE_CODEC = ComparableDoubleCodec.INSTANCE;

    public static byte[] toComparableBytes(double value) {
        return COMPARABLE_CODEC.encode(value);
    }

    public static double fromComparableBytes(byte[] comparableBytes, int offset) {
        return COMPARABLE_CODEC.decode(comparableBytes, offset);
    }

    private static Double fromBytesNullable(byte[] bytes, int offset) {
        Long longValue = LongByteTool.fromRawBytes(bytes, offset);
        if (longValue == 0x10000000000000L) {
            return null;
        }
        return Double.longBitsToDouble(longValue);
    }

    private static byte[] getBytesNullable(Double in) {
        if (in == null) {
            return DoubleByteTool.getBytes(Double.longBitsToDouble(0x10000000000000L));
        }
        return DoubleByteTool.getBytes(in);
    }

    public static byte[] getBytes(double in) {
        return RAW_CODEC.encode(in);
    }

    public static int toBytes(double in, byte[] bytes, int offset) {
        return RAW_CODEC.encode(in, bytes, offset);
    }

    public static double fromBytes(byte[] bytes, int offset) {
        return RAW_CODEC.decode(bytes, offset);
    }

    public static List<Double> fromDoubleByteArray(byte[] bytes, int startIdx) {
        int numDoubles = (bytes.length - startIdx) / 8;
        ArrayList<Double> doubles = new ArrayList<Double>();
        byte[] arrayToCopy = new byte[8];
        int i = 0;
        while (i < numDoubles) {
            System.arraycopy(bytes, i * 8 + startIdx, arrayToCopy, 0, 8);
            doubles.add(DoubleByteTool.fromBytesNullable(arrayToCopy, 0));
            ++i;
        }
        return doubles;
    }

    public static byte[] getDoubleByteArray(List<Double> valuesWithNulls) {
        if (valuesWithNulls == null) {
            return null;
        }
        byte[] out = new byte[8 * valuesWithNulls.size()];
        int i = 0;
        while (i < valuesWithNulls.size()) {
            System.arraycopy(DoubleByteTool.getBytesNullable(valuesWithNulls.get(i)), 0, out, i * 8, 8);
            ++i;
        }
        return out;
    }
}

