/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.BooleanByteTool;
import io.datarouter.bytes.IntegerByteTool;
import io.datarouter.bytes.LongByteTool;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.scanner.Scanner;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.CRC32;

public class ByteWriter {
    private final int pageSize;
    private final List<byte[]> pages;
    private int lastPageSize;

    public ByteWriter(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize must be > 0");
        }
        this.pageSize = pageSize;
        this.pages = new ArrayList<byte[]>();
        this.lastPageSize = 0;
    }

    public int length() {
        int numFullPages = this.pages.isEmpty() ? 0 : this.pages.size() - 1;
        return numFullPages * this.pageSize + this.lastPageSize;
    }

    public byte[][] trimmedPages() {
        if (this.pages.isEmpty()) {
            return new byte[0][];
        }
        byte[][] trimmedPages = new byte[this.pages.size()][];
        int nextPageIndex = 0;
        int i = 0;
        while (i < this.pages.size() - 1) {
            trimmedPages[nextPageIndex++] = this.pages.get(i);
            ++i;
        }
        if (this.lastPageSize == this.pageSize) {
            trimmedPages[nextPageIndex++] = this.lastPage();
        } else {
            byte[] trimmedLastPage = new byte[this.lastPageSize];
            System.arraycopy(this.lastPage(), 0, trimmedLastPage, 0, this.lastPageSize);
            trimmedPages[nextPageIndex++] = trimmedLastPage;
        }
        return trimmedPages;
    }

    public byte[] concat() {
        return this.concat(0, this.length());
    }

    public byte[] concat(int from, int to) {
        int pageIndex = from / this.pageSize;
        int byteIndex = from % this.pageSize;
        int copied = 0;
        int remaining = to - from;
        byte[] output = new byte[remaining];
        while (remaining > 0) {
            int remainingInPage = this.getPageSize(pageIndex) - byteIndex;
            int copyLength = Math.min(remaining, remainingInPage);
            System.arraycopy(this.pages.get(pageIndex), byteIndex, output, copied, copyLength);
            copied += copyLength;
            remaining -= copyLength;
            ++pageIndex;
            byteIndex = 0;
        }
        return output;
    }

    private int getPageSize(int index) {
        if (index == this.pages.size() - 1) {
            return this.lastPageSize;
        }
        return this.pageSize;
    }

    private byte[] lastPage() {
        return this.pages.get(this.pages.size() - 1);
    }

    private int lastPageFreeSpace() {
        if (this.pages.isEmpty()) {
            return 0;
        }
        return this.pageSize - this.lastPageSize;
    }

    private void addPageIfFull() {
        if (this.pages.isEmpty() || this.lastPageSize == this.pageSize) {
            this.pages.add(new byte[this.pageSize]);
            this.lastPageSize = 0;
        }
    }

    public long crc32() {
        CRC32 checksum = new CRC32();
        Scanner.iterate((Object)0, i -> i + 1).limit((long)this.pages.size()).forEach(pageIndex -> checksum.update(this.pages.get((int)pageIndex), 0, this.getPageSize((int)pageIndex)));
        return checksum.getValue();
    }

    public String toString() {
        return (String)Scanner.iterate((Object)0, i -> i + 1).limit((long)this.pages.size()).map(pageIndex -> Arrays.copyOf(this.pages.get((int)pageIndex), this.getPageSize((int)pageIndex))).map(Arrays::toString).collect(Collectors.joining("\n"));
    }

    public ByteWriter bytes(byte[] value) {
        return this.bytes(value, 0, value.length);
    }

    public ByteWriter bytes(byte[] value, int from, int to) {
        int length = to - from;
        if (length == 0) {
            return this;
        }
        int inputOffset = from;
        int inputRemaining = length;
        while (inputRemaining > 0) {
            this.addPageIfFull();
            int chunkLength = Math.min(inputRemaining, this.lastPageFreeSpace());
            System.arraycopy(value, inputOffset, this.lastPage(), this.lastPageSize, chunkLength);
            inputOffset += chunkLength;
            inputRemaining -= chunkLength;
            this.lastPageSize += chunkLength;
        }
        return this;
    }

    public ByteWriter varBytes(byte[] value) {
        this.bytes(VarIntTool.encode(value.length));
        this.bytes(value);
        return this;
    }

    public ByteWriter booleanByte(boolean value) {
        this.bytes(BooleanByteTool.getBytes(value));
        return this;
    }

    public ByteWriter rawInt(int value) {
        if (this.lastPageFreeSpace() < 4) {
            this.bytes(IntegerByteTool.getRawBytes(value));
        } else {
            IntegerByteTool.toRawBytes(value, this.lastPage(), this.lastPageSize);
            this.lastPageSize += 4;
        }
        return this;
    }

    public ByteWriter rawInts(int[] values) {
        int i = 0;
        while (i < values.length) {
            this.rawInt(values[i]);
            ++i;
        }
        return this;
    }

    public ByteWriter varInt(int value) {
        this.bytes(VarIntTool.encode(value));
        return this;
    }

    public ByteWriter comparableLong(long value) {
        if (this.lastPageFreeSpace() < 8) {
            this.bytes(LongByteTool.getComparableBytes(value));
        } else {
            LongByteTool.toComparableBytes(value, this.lastPage(), this.lastPageSize);
            this.lastPageSize += 8;
        }
        return this;
    }

    public ByteWriter rawLong(long value) {
        if (this.lastPageFreeSpace() < 8) {
            this.bytes(LongByteTool.getRawBytes(value));
        } else {
            LongByteTool.toRawBytes(value, this.lastPage(), this.lastPageSize);
            this.lastPageSize += 8;
        }
        return this;
    }

    public ByteWriter rawLongs(long[] values) {
        int i = 0;
        while (i < values.length) {
            this.rawLong(values[i]);
            ++i;
        }
        return this;
    }

    public ByteWriter varLong(long value) {
        this.bytes(VarIntTool.encode(value));
        return this;
    }

    public ByteWriter varUtf8(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.varBytes(bytes);
        return this;
    }

    public ByteWriter comparableUtf8(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.bytes(bytes);
        this.bytes(new byte[1]);
        return this;
    }
}

