/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.math.BigDecimal;
import java.math.MathContext;

public enum ByteUnitType {
    BYTE(1L, ByteUnitName.BYTE_DEC),
    KB(ByteUnitType.BYTE.numBytes * ByteUnitSystem.access$2(ByteUnitName.access$2(ByteUnitName.BYTE_DEC)), ByteUnitName.KB),
    MB(ByteUnitType.KB.numBytes * ByteUnitSystem.access$2(ByteUnitName.access$2(ByteUnitName.MB)), ByteUnitName.MB),
    GB(ByteUnitType.MB.numBytes * ByteUnitSystem.access$2(ByteUnitName.access$2(ByteUnitName.GB)), ByteUnitName.GB),
    TB(ByteUnitType.GB.numBytes * ByteUnitSystem.access$2(ByteUnitName.access$2(ByteUnitName.TB)), ByteUnitName.TB),
    PB(ByteUnitType.TB.numBytes * ByteUnitSystem.access$2(ByteUnitName.access$2(ByteUnitName.PB)), ByteUnitName.PB),
    KiB(ByteUnitType.BYTE.numBytes * ByteUnitSystem.access$2(ByteUnitName.access$2(ByteUnitName.BYTE_BIN)), ByteUnitName.KiB),
    MiB(ByteUnitType.KiB.numBytes * ByteUnitSystem.access$2(ByteUnitName.access$2(ByteUnitName.MiB)), ByteUnitName.MiB),
    GiB(ByteUnitType.MiB.numBytes * ByteUnitSystem.access$2(ByteUnitName.access$2(ByteUnitName.GiB)), ByteUnitName.GiB),
    TiB(ByteUnitType.GiB.numBytes * ByteUnitSystem.access$2(ByteUnitName.access$2(ByteUnitName.TiB)), ByteUnitName.TiB),
    PiB(ByteUnitType.TiB.numBytes * ByteUnitSystem.access$2(ByteUnitName.access$2(ByteUnitName.PiB)), ByteUnitName.PiB);

    private final long numBytes;
    private final ByteUnitName unitName;
    public static final ByteUnitType[] BIN_SORTED_ASC;
    private static final ByteUnitType[] DEC_SORTED_ASC;
    private static final ByteUnitSystem DEFAULT_UNIT_SYSTEM;

    static {
        BIN_SORTED_ASC = new ByteUnitType[]{BYTE, KiB, MiB, GiB, TiB, PiB};
        DEC_SORTED_ASC = new ByteUnitType[]{BYTE, KB, MB, GB, TB, PB};
        DEFAULT_UNIT_SYSTEM = ByteUnitSystem.BINARY;
    }

    private ByteUnitType(long numBytes, ByteUnitName unitName) {
        this.numBytes = numBytes;
        this.unitName = unitName;
    }

    public static ByteUnitType[] getAscValues(ByteUnitSystem byteUnitSystem) {
        if (byteUnitSystem == null) {
            byteUnitSystem = DEFAULT_UNIT_SYSTEM;
        }
        if (ByteUnitSystem.DECIMAL == byteUnitSystem) {
            return DEC_SORTED_ASC;
        }
        return BIN_SORTED_ASC;
    }

    public static String getNumBytesDisplay(long value, ByteUnitType toByteUnit) {
        if (value < 0L || toByteUnit == null) {
            return null;
        }
        double numBytes = ByteUnitType.getNumBytes(value, toByteUnit);
        BigDecimal bigDecimal = new BigDecimal(numBytes).round(new MathContext(3));
        return String.valueOf(bigDecimal.toPlainString()) + " " + toByteUnit.getByteUnitName().getShortName();
    }

    public String getNumBytesDisplay(long value) {
        return ByteUnitType.getNumBytesDisplay(value, this);
    }

    public static double getNumBytes(long numBytes, ByteUnitType toByteUnit) {
        if (numBytes < 0L || toByteUnit == null) {
            return -1.0;
        }
        return (double)numBytes / (double)toByteUnit.getNumBytes();
    }

    public long getNumBytes() {
        return this.numBytes;
    }

    public ByteUnitName getByteUnitName() {
        return this.unitName;
    }

    public long toBytes(long input) {
        return input * this.numBytes;
    }

    public int toBytesInt(long input) {
        return (int)(input * this.numBytes);
    }

    private static enum ByteUnitName {
        BYTE_DEC("B", ByteUnitSystem.DECIMAL),
        KB("KB", ByteUnitSystem.DECIMAL),
        MB("MB", ByteUnitSystem.DECIMAL),
        GB("GB", ByteUnitSystem.DECIMAL),
        TB("TB", ByteUnitSystem.DECIMAL),
        PB("PB", ByteUnitSystem.DECIMAL),
        BYTE_BIN("B", ByteUnitSystem.BINARY),
        KiB("KiB", ByteUnitSystem.BINARY),
        MiB("MiB", ByteUnitSystem.BINARY),
        GiB("GiB", ByteUnitSystem.BINARY),
        TiB("TiB", ByteUnitSystem.BINARY),
        PiB("PiB", ByteUnitSystem.BINARY);

        private final String shortName;
        private final ByteUnitSystem unitSystem;

        private ByteUnitName(String shortName, ByteUnitSystem unitSystem) {
            this.shortName = shortName;
            this.unitSystem = unitSystem;
        }

        private String getShortName() {
            return this.shortName;
        }

        static /* synthetic */ ByteUnitSystem access$2(ByteUnitName byteUnitName) {
            return byteUnitName.unitSystem;
        }
    }

    public static enum ByteUnitSystem {
        DECIMAL(1000L),
        BINARY(1024L);

        private final long step;

        private ByteUnitSystem(long step) {
            this.step = step;
        }

        public long getStep() {
            return this.step;
        }

        static /* synthetic */ long access$2(ByteUnitSystem byteUnitSystem) {
            return byteUnitSystem.step;
        }
    }
}

