/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.codec.booleancodec.RawBooleanCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BooleanByteTool {
    private static final int NULL = -2;
    private static RawBooleanCodec RAW_CODEC = RawBooleanCodec.INSTANCE;

    private static byte[] getBytesNullable(Boolean value) {
        if (value == null) {
            return new byte[]{-2};
        }
        return BooleanByteTool.getBytes(value);
    }

    private static Boolean fromBytesNullable(byte[] bytes, int offset) {
        if (Arrays.equals(bytes, new byte[]{-2})) {
            return null;
        }
        return BooleanByteTool.fromBytes(bytes, offset);
    }

    public static byte[] getBytes(boolean value) {
        return RAW_CODEC.encode(value);
    }

    public static int toBytes(boolean value, byte[] bytes, int offset) {
        return RAW_CODEC.encode(value, bytes, offset);
    }

    public static boolean fromBytes(byte[] bytes, int offset) {
        return RAW_CODEC.decode(bytes, offset);
    }

    public static byte[] getBooleanByteArray(List<Boolean> valuesWithNulls) {
        if (valuesWithNulls == null) {
            return null;
        }
        byte[] out = new byte[valuesWithNulls.size()];
        int i = 0;
        while (i < valuesWithNulls.size()) {
            System.arraycopy(BooleanByteTool.getBytesNullable(valuesWithNulls.get(i)), 0, out, i, 1);
            ++i;
        }
        return out;
    }

    public static List<Boolean> fromBooleanByteArray(byte[] bytes, int startIdx) {
        int numBooleans = bytes.length - startIdx;
        ArrayList<Boolean> bools = new ArrayList<Boolean>();
        byte[] arrayToCopy = new byte[1];
        int i = 0;
        while (i < numBooleans) {
            System.arraycopy(bytes, i + startIdx, arrayToCopy, 0, 1);
            bools.add(BooleanByteTool.fromBytesNullable(arrayToCopy, 0));
            ++i;
        }
        return bools;
    }
}

