/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.primitivelist;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.primitivelist.BasePrimitiveList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PrimitiveFloatList
extends BasePrimitiveList<Float> {
    private static final PrimitiveFloatList EMPTY = new PrimitiveFloatList(EmptyArray.FLOAT);
    private final float[] array;

    public PrimitiveFloatList(float[] array) {
        this(array, 0, array.length);
    }

    public PrimitiveFloatList(float[] array, int from, int to) {
        super(from, to);
        this.array = array;
    }

    public PrimitiveFloatList(Collection<Float> values) {
        super(0, values.size());
        this.array = new float[values.size()];
        this.initFromCollection(values);
    }

    public static PrimitiveFloatList empty() {
        return EMPTY;
    }

    @Override
    protected boolean internalEquals(Object object) {
        if (object instanceof PrimitiveFloatList) {
            PrimitiveFloatList that = (PrimitiveFloatList)object;
            return Arrays.equals(this.array, this.from, this.to, that.array, that.from, that.to);
        }
        return false;
    }

    @Override
    protected int internalFirstIndexOf(Object obj) {
        float value = ((Float)obj).floatValue();
        int i = this.from;
        while (i < this.to) {
            if (this.array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected Float internalGet(int index) {
        return Float.valueOf(this.array[this.from + index]);
    }

    @Override
    protected int internalHashCode() {
        int result = 1;
        int i = this.from;
        while (i < this.to) {
            result = 31 * result + Float.floatToIntBits(this.array[i]);
            ++i;
        }
        return result;
    }

    @Override
    protected boolean internalIsCorrectType(Object object) {
        return object instanceof Float;
    }

    @Override
    protected int internalLastIndexOf(Object obj) {
        float value = ((Float)obj).floatValue();
        int i = this.to - 1;
        while (i >= this.from) {
            if (this.array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    protected Float internalSet(int index, Float value) {
        float oldValue = this.array[index];
        this.array[this.from + index] = value.floatValue();
        return Float.valueOf(oldValue);
    }

    @Override
    protected List<Float> internalSubList(int fromIndex, int toIndex) {
        return new PrimitiveFloatList(this.array, this.from + fromIndex, this.from + toIndex);
    }
}

