/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.io;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.Scanner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MultiByteArrayInputStream
extends InputStream {
    private final Scanner<byte[]> scanner;
    private byte[] current;
    private int position;

    public MultiByteArrayInputStream(Scanner<byte[]> arrays) {
        this.scanner = arrays;
        this.current = EmptyArray.BYTE;
        this.position = 0;
    }

    public MultiByteArrayInputStream(List<byte[]> arrays) {
        this(MemoryFreeingScanner.of(arrays));
    }

    @Override
    public int read() {
        while (this.remainingInCurrent() == 0 && this.advance()) {
        }
        if (this.remainingInCurrent() == 0) {
            return -1;
        }
        byte value = this.current[this.position];
        ++this.position;
        return Byte.toUnsignedInt(value);
    }

    @Override
    public int read(byte[] destination, int off, int len) {
        if (len == 0) {
            return 0;
        }
        int count = 0;
        int destinationCursor = off;
        while (count < len) {
            int numCurrent = this.remainingInCurrent();
            if (numCurrent > 0) {
                int numPending = len - count;
                int copySize = Math.min(numPending, numCurrent);
                System.arraycopy(this.current, this.position, destination, destinationCursor, copySize);
                this.position += copySize;
                count += copySize;
                destinationCursor += copySize;
            }
            if (count == len || !this.advance()) break;
        }
        return count == 0 ? -1 : count;
    }

    @Override
    public byte[] readAllBytes() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(this.current, this.position, this.remainingInCurrent());
        while (this.advance()) {
            buffer.write(this.current, this.position, this.remainingInCurrent());
        }
        this.current = EmptyArray.BYTE;
        this.position = 0;
        return buffer.toByteArray();
    }

    @Override
    public byte[] readNBytes(int len) {
        byte[] buffer = new byte[len];
        int numRead = this.readNBytes(buffer, 0, len);
        return numRead == len ? buffer : Arrays.copyOf(buffer, numRead);
    }

    @Override
    public int readNBytes(byte[] buffer, int off, int len) {
        int numBytesRead = this.read(buffer, off, len);
        return numBytesRead == -1 ? 0 : numBytesRead;
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        long count = 0L;
        count += (long)this.remainingInCurrent();
        out.write(this.current, this.position, this.remainingInCurrent());
        while (this.advance()) {
            count += (long)this.remainingInCurrent();
            out.write(this.current, this.position, this.remainingInCurrent());
        }
        this.current = EmptyArray.BYTE;
        this.position = 0;
        return count;
    }

    @Override
    public void close() {
        this.scanner.close();
    }

    private int remainingInCurrent() {
        return this.current.length - this.position;
    }

    private boolean advance() {
        this.position = 0;
        if (this.scanner.advance()) {
            this.current = (byte[])this.scanner.current();
            return true;
        }
        this.current = EmptyArray.BYTE;
        return false;
    }

    private static class MemoryFreeingScanner<T>
    extends BaseScanner<T> {
        private final ArrayList<T> list;
        private int index = -1;

        public MemoryFreeingScanner(Collection<T> list) {
            this.list = new ArrayList<T>(list);
        }

        public static <T> Scanner<T> of(Collection<T> list) {
            return new MemoryFreeingScanner<T>(list);
        }

        public boolean advance() {
            if (this.index >= 0 && this.index < this.list.size()) {
                this.list.set(this.index, null);
            }
            ++this.index;
            return this.index < this.list.size();
        }

        public T current() {
            return this.list.get(this.index);
        }
    }
}

