/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.stringcodec;

import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.TerminatedByteArrayTool;
import io.datarouter.bytes.codec.stringcodec.StringCodec;

public class TerminatedStringCodec {
    public static final TerminatedStringCodec US_ASCII = new TerminatedStringCodec(StringCodec.US_ASCII);
    public static final TerminatedStringCodec ISO_8859_1 = new TerminatedStringCodec(StringCodec.ISO_8859_1);
    public static final TerminatedStringCodec UTF_8 = new TerminatedStringCodec(StringCodec.UTF_8);
    private final StringCodec stringCodec;

    public TerminatedStringCodec(StringCodec stringCodec) {
        this.stringCodec = stringCodec;
    }

    public byte[] encode(String value) {
        byte[] encodedBytes = this.stringCodec.encode(value);
        return TerminatedByteArrayTool.escapeAndTerminate(encodedBytes);
    }

    public LengthAndValue<String> decode(byte[] bytes) {
        return this.decode(bytes, 0);
    }

    public LengthAndValue<String> decode(byte[] bytes, int offset) {
        TerminatedByteArrayTool.NumEscapedAndTerminalIndex numEscapedAndTerminalIndex = TerminatedByteArrayTool.findEscapedCountAndTerminalIndex(bytes, offset);
        int numEscaped = numEscapedAndTerminalIndex.numEscaped;
        int terminalIndex = numEscapedAndTerminalIndex.terminalIndex;
        int consumedLength = terminalIndex - offset + 1;
        if (numEscaped == 0) {
            int escapedLength = terminalIndex - offset;
            String value = this.stringCodec.decode(bytes, offset, escapedLength);
            return new LengthAndValue<String>(consumedLength, value);
        }
        byte[] unescapedAndUnterminatedBytes = TerminatedByteArrayTool.unescapeAndUnterminate(bytes, offset, numEscaped, terminalIndex);
        String value = this.stringCodec.decode(unescapedAndUnterminatedBytes);
        return new LengthAndValue<String>(consumedLength, value);
    }
}

