/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.stringcodec;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.bytes.varint.VarIntTool;

public class PrefixedStringCodec {
    public static final PrefixedStringCodec US_ASCII = new PrefixedStringCodec(StringCodec.US_ASCII);
    public static final PrefixedStringCodec ISO_8859_1 = new PrefixedStringCodec(StringCodec.ISO_8859_1);
    public static final PrefixedStringCodec UTF_8 = new PrefixedStringCodec(StringCodec.UTF_8);
    private final StringCodec stringCodec;

    public PrefixedStringCodec(StringCodec stringCodec) {
        this.stringCodec = stringCodec;
    }

    public byte[] encode(String value) {
        byte[] valueBytes = this.stringCodec.encode(value);
        byte[] lengthBytes = VarIntTool.encode(valueBytes.length);
        return ByteTool.concat(lengthBytes, valueBytes);
    }

    public int encode(String value, byte[] bytes, int offset) {
        byte[] valueBytes = this.stringCodec.encode(value);
        byte[] lengthBytes = VarIntTool.encode(valueBytes.length);
        int cursor = offset;
        System.arraycopy(lengthBytes, 0, bytes, cursor, lengthBytes.length);
        cursor += lengthBytes.length;
        System.arraycopy(valueBytes, 0, bytes, offset, valueBytes.length);
        return (cursor += valueBytes.length) - offset;
    }

    public String decode(byte[] bytes) {
        return this.decode(bytes, 0);
    }

    public String decode(byte[] bytes, int offset) {
        return this.decodeWithLength(bytes, offset).value();
    }

    public LengthAndValue<String> decodeWithLength(byte[] bytes, int offset) {
        int cursor = offset;
        int valueBytesLength = VarIntTool.decodeInt(bytes, cursor);
        String value = this.stringCodec.decode(bytes, cursor += VarIntTool.length(valueBytesLength), valueBytesLength);
        int length = (cursor += valueBytesLength) - offset;
        return new LengthAndValue<String>(length, value);
    }
}

