/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.longcodec;

public class RawLongCodec {
    public static final RawLongCodec INSTANCE = new RawLongCodec();
    private static final int LENGTH = 8;

    public int length() {
        return 8;
    }

    public byte[] encode(long value) {
        byte[] bytes = new byte[8];
        this.encode(value, bytes, 0);
        return bytes;
    }

    public int encode(long value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value >>> 56);
        bytes[offset + 1] = (byte)(value >>> 48);
        bytes[offset + 2] = (byte)(value >>> 40);
        bytes[offset + 3] = (byte)(value >>> 32);
        bytes[offset + 4] = (byte)(value >>> 24);
        bytes[offset + 5] = (byte)(value >>> 16);
        bytes[offset + 6] = (byte)(value >>> 8);
        bytes[offset + 7] = (byte)value;
        return 8;
    }

    public long decode(byte[] bytes) {
        return this.decode(bytes, 0);
    }

    public long decode(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }
}

