/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.row;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.blockfile.row.BlockfileRowOp;
import io.datarouter.bytes.blockfile.row.BlockfileRowVersionCodec;
import io.datarouter.bytes.codec.bytestringcodec.HexByteStringCodec;
import java.util.Arrays;
import java.util.Objects;

public class BlockfileRowVersion {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private final int keyOffset;
    private final int keyLength;
    private final int versionOffset;
    private final int versionLength;
    private final BlockfileRowOp op;

    public BlockfileRowVersion(byte[] bytes, int offset, int length, int keyOffset, int keyLength, int versionOffset, int versionLength, BlockfileRowOp op) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(op);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.keyOffset = keyOffset;
        this.keyLength = keyLength;
        this.versionOffset = versionOffset;
        this.versionLength = versionLength;
        this.op = op;
    }

    public static BlockfileRowVersion create(byte[] key, byte[] version, BlockfileRowOp op) {
        return BlockfileRowVersionCodec.create(key, version, op);
    }

    public static BlockfileRowVersion putWithoutVersion(byte[] key) {
        return BlockfileRowVersion.create(key, EmptyArray.BYTE, BlockfileRowOp.PUT);
    }

    public int compareKeyBytes(byte[] otherBytes, int otherOffset, int otherLength) {
        return Arrays.compareUnsigned(this.bytes, this.keyOffset, this.keyOffset + this.keyLength, otherBytes, otherOffset, otherOffset + otherLength);
    }

    public boolean equalsKeyBytes(byte[] otherBytes, int otherOffset, int otherLength) {
        return Arrays.equals(this.bytes, this.keyOffset, this.keyOffset + this.keyLength, otherBytes, otherOffset, otherOffset + otherLength);
    }

    public static boolean equalsKeyOptimized(BlockfileRowVersion left, BlockfileRowVersion right) {
        if (left.keyLength != right.keyLength) {
            return false;
        }
        if (left.keyLength == 0) {
            return true;
        }
        int leftTo = left.keyOffset + left.keyLength;
        int rightTo = right.keyOffset + right.keyLength;
        if (left.bytes[leftTo - 1] != right.bytes[rightTo - 1]) {
            return false;
        }
        return Arrays.equals(left.bytes, left.keyOffset, leftTo, right.bytes, right.keyOffset, rightTo);
    }

    public static boolean equalsVersion(BlockfileRowVersion left, BlockfileRowVersion right) {
        int leftTo = left.versionOffset + left.versionLength;
        int rightTo = right.versionOffset + right.versionLength;
        return Arrays.equals(left.bytes, left.versionOffset, leftTo, right.bytes, right.versionOffset, rightTo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockfileRowVersion other = (BlockfileRowVersion)obj;
        return Arrays.equals(this.bytes, this.offset, this.offset + this.length, other.bytes, other.offset, other.offset + other.length);
    }

    public int hashCode() {
        int result = 1;
        int i = this.offset;
        while (i < this.length) {
            result = 31 * result + this.bytes[i];
            ++i;
        }
        return result;
    }

    public int compareToKey(byte[] otherKey) {
        return Arrays.compareUnsigned(this.bytes, this.keyOffset, this.keyOffset + this.keyLength, otherKey, 0, otherKey.length);
    }

    public static int compareKey(BlockfileRowVersion left, BlockfileRowVersion right) {
        return Arrays.compareUnsigned(left.bytes, left.keyOffset, left.keyOffset + left.keyLength, right.bytes, right.keyOffset, right.keyOffset + right.keyLength);
    }

    public static int compareVersion(BlockfileRowVersion left, BlockfileRowVersion right) {
        return Arrays.compareUnsigned(left.bytes, left.versionOffset, left.versionOffset + left.versionLength, right.bytes, right.versionOffset, right.versionOffset + right.versionLength);
    }

    public static int compareKeyVersionOpOptimized(BlockfileRowVersion left, BlockfileRowVersion right) {
        int keyDiff = BlockfileRowVersion.compareKey(left, right);
        if (keyDiff != 0) {
            return keyDiff;
        }
        int versionDiff = BlockfileRowVersion.compareVersion(left, right);
        if (versionDiff != 0) {
            return versionDiff;
        }
        return left.op.compareTo(right.op);
    }

    public byte[] backingBytes() {
        return this.bytes;
    }

    public byte[] copyOfBytes() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public int keyOffset() {
        return this.keyOffset;
    }

    public int keyLength() {
        return this.keyLength;
    }

    public byte[] copyOfKey() {
        return Arrays.copyOfRange(this.bytes, this.keyOffset, this.keyOffset + this.keyLength);
    }

    public int versionOffset() {
        return this.versionOffset;
    }

    public int versionLength() {
        return this.versionLength;
    }

    public byte[] copyOfVersion() {
        return Arrays.copyOfRange(this.bytes, this.versionOffset, this.versionOffset + this.versionLength);
    }

    public BlockfileRowOp op() {
        return this.op;
    }

    public String toString() {
        return HexByteStringCodec.INSTANCE.encode(this.copyOfBytes());
    }
}

