/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.row;

import io.datarouter.bytes.io.InputStreamTool;
import java.io.InputStream;
import java.util.Comparator;

public enum BlockfileRowOp {
    DELETE(0),
    PUT(1);

    public static final int NUM_PERSISTENT_BYTES = 1;
    public static final Comparator<BlockfileRowOp> COMPARATOR;
    private static final BlockfileRowOp[] PERSISTENT_VALUE_LOOKUP_TABLE;
    public final byte persistentValue;
    public final byte[] persistentValueArray;

    static {
        COMPARATOR = Comparator.comparing(op -> op.persistentValue);
        PERSISTENT_VALUE_LOOKUP_TABLE = new BlockfileRowOp[]{DELETE, PUT};
    }

    private BlockfileRowOp(byte persistentValue) {
        this.persistentValue = persistentValue;
        this.persistentValueArray = new byte[]{persistentValue};
    }

    public static BlockfileRowOp fromByte(byte value) {
        return PERSISTENT_VALUE_LOOKUP_TABLE[value];
    }

    public static BlockfileRowOp fromInputStream(InputStream inputStream) {
        byte value = InputStreamTool.readRequiredByte(inputStream);
        return PERSISTENT_VALUE_LOOKUP_TABLE[value];
    }
}

