/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.row;

import io.datarouter.bytes.blockfile.row.BlockfileRow;
import io.datarouter.bytes.blockfile.row.BlockfileRowOp;
import io.datarouter.bytes.varint.VarIntTool;

public class BlockfileRowCodec {
    public static int length(byte[] key, byte[] version, byte[] value) {
        return VarIntTool.length(key.length) + key.length + VarIntTool.length(version.length) + version.length + 1 + VarIntTool.length(value.length) + value.length;
    }

    public static BlockfileRow create(byte[] key, byte[] version, BlockfileRowOp op, byte[] value) {
        int keyLengthOffset = 0;
        int keyOffset = keyLengthOffset + VarIntTool.length(key.length);
        int versionLengthOffset = keyOffset + key.length;
        int versionOffset = versionLengthOffset + VarIntTool.length(version.length);
        int opOffset = versionOffset + version.length;
        int valueLengthOffset = opOffset + 1;
        int valueOffset = valueLengthOffset + VarIntTool.length(value.length);
        int length = valueOffset + value.length;
        byte[] bytes = new byte[length];
        BlockfileRowCodec.encodeInto(key, version, op, value, bytes, 0);
        return new BlockfileRow(bytes, 0, length, keyOffset, key.length, versionOffset, version.length, op, valueOffset, value.length);
    }

    public static byte[] encode(byte[] key, byte[] version, BlockfileRowOp op, byte[] value) {
        int length = BlockfileRowCodec.length(key, version, value);
        byte[] intoBytes = new byte[length];
        BlockfileRowCodec.encodeInto(key, version, op, value, intoBytes, 0);
        return intoBytes;
    }

    public static void encodeInto(byte[] key, byte[] version, BlockfileRowOp op, byte[] value, byte[] intoBytes, int offset) {
        int cursor = offset;
        cursor += VarIntTool.encode(intoBytes, cursor, key.length);
        System.arraycopy(key, 0, intoBytes, cursor, key.length);
        cursor += key.length;
        cursor += VarIntTool.encode(intoBytes, cursor, version.length);
        System.arraycopy(version, 0, intoBytes, cursor, version.length);
        intoBytes[cursor += version.length] = op.persistentValue;
        ++cursor;
        cursor += VarIntTool.encode(intoBytes, cursor, value.length);
        System.arraycopy(value, 0, intoBytes, cursor, value.length);
        cursor += value.length;
    }

    public static BlockfileRow fromBytes(byte[] bytes) {
        return BlockfileRowCodec.fromBytes(bytes, 0);
    }

    public static BlockfileRow fromBytes(byte[] bytes, int offset) {
        int cursor = offset;
        int keyLength = VarIntTool.decodeInt(bytes, cursor);
        int keyOffset = cursor += VarIntTool.length(keyLength);
        int versionLength = VarIntTool.decodeInt(bytes, cursor += keyLength);
        int versionOffset = cursor += VarIntTool.length(versionLength);
        BlockfileRowOp op = BlockfileRowOp.fromByte(bytes[cursor += versionLength]);
        int valueLength = 0;
        int valueOffset = ++cursor;
        valueLength = VarIntTool.decodeInt(bytes, cursor);
        valueOffset = cursor += VarIntTool.length(valueLength);
        int length = (cursor += valueLength) - offset;
        return new BlockfileRow(bytes, offset, length, keyOffset, keyLength, versionOffset, versionLength, op, valueOffset, valueLength);
    }
}

