/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.row;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.blockfile.row.BlockfileRowCodec;
import io.datarouter.bytes.blockfile.row.BlockfileRowOp;
import io.datarouter.bytes.blockfile.row.BlockfileRowVersion;
import io.datarouter.bytes.blockfile.row.BlockfileRowVersionCodec;
import io.datarouter.bytes.codec.bytestringcodec.HexByteStringCodec;
import io.datarouter.bytes.codec.longcodec.ComparableLongCodec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class BlockfileRow {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private final int keyOffset;
    private final int keyLength;
    private final int versionOffset;
    private final int versionLength;
    private final BlockfileRowOp op;
    private final int valueOffset;
    private final int valueLength;

    public BlockfileRow(byte[] bytes, int offset, int length, int keyOffset, int keyLength, int versionOffset, int versionLength, BlockfileRowOp op, int valueOffset, int valueLength) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(op);
        if (op == BlockfileRowOp.DELETE && valueLength != 0) {
            throw new IllegalArgumentException("Cannot have value with delete op");
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.keyOffset = keyOffset;
        this.keyLength = keyLength;
        this.versionOffset = versionOffset;
        this.versionLength = versionLength;
        this.op = op;
        this.valueOffset = valueOffset;
        this.valueLength = valueLength;
        if (length != valueOffset + valueLength - offset) {
            String message = String.format("length[%s] != valueOffset[%s]+valueLength[%s]", length, valueOffset, valueLength);
            throw new IllegalArgumentException(message);
        }
    }

    public static BlockfileRow create(byte[] key, byte[] version, BlockfileRowOp op, byte[] value) {
        return BlockfileRowCodec.create(key, version, op, value);
    }

    public static BlockfileRow delete(byte[] key, byte[] version) {
        return BlockfileRow.create(key, version, BlockfileRowOp.DELETE, EmptyArray.BYTE);
    }

    public static BlockfileRow putWithoutVersion(byte[] key, byte[] value) {
        return BlockfileRow.create(key, EmptyArray.BYTE, BlockfileRowOp.PUT, value);
    }

    public static BlockfileRow putWithLongVersion(byte[] key, long version, byte[] value) {
        return BlockfileRow.create(key, ComparableLongCodec.INSTANCE.encode(version), BlockfileRowOp.PUT, value);
    }

    public boolean equalsKey(byte[] otherKey) {
        return Arrays.equals(this.bytes, this.keyOffset, this.keyOffset + this.keyLength, otherKey, 0, otherKey.length);
    }

    public static boolean equalsKeyOptimized(BlockfileRow left, BlockfileRow right) {
        if (left.keyLength != right.keyLength) {
            return false;
        }
        if (left.keyLength == 0) {
            return true;
        }
        int leftTo = left.keyOffset + left.keyLength;
        int rightTo = right.keyOffset + right.keyLength;
        if (left.bytes[leftTo - 1] != right.bytes[rightTo - 1]) {
            return false;
        }
        return Arrays.equals(left.bytes, left.keyOffset, leftTo, right.bytes, right.keyOffset, rightTo);
    }

    public static boolean equalsVersion(BlockfileRow left, BlockfileRow right) {
        int leftTo = left.versionOffset + left.versionLength;
        int rightTo = right.versionOffset + right.versionLength;
        return Arrays.equals(left.bytes, left.versionOffset, leftTo, right.bytes, right.versionOffset, rightTo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockfileRow other = (BlockfileRow)obj;
        return Arrays.equals(this.bytes, this.offset, this.offset + this.length, other.bytes, other.offset, other.offset + other.length);
    }

    public int hashCode() {
        int result = 1;
        int i = this.offset;
        while (i < this.length) {
            result = 31 * result + this.bytes[i];
            ++i;
        }
        return result;
    }

    public String toString() {
        return String.format("%s-%s-%s-%s", new Object[]{HexByteStringCodec.INSTANCE.encode(this.copyOfKey()), HexByteStringCodec.INSTANCE.encode(this.copyOfVersion()), this.op(), HexByteStringCodec.INSTANCE.encode(this.copyOfValue())});
    }

    public int compareToKey(byte[] otherKey) {
        return Arrays.compareUnsigned(this.bytes, this.keyOffset, this.keyOffset + this.keyLength, otherKey, 0, otherKey.length);
    }

    public static int compareKey(BlockfileRow left, BlockfileRow right) {
        return Arrays.compareUnsigned(left.bytes, left.keyOffset, left.keyOffset + left.keyLength, right.bytes, right.keyOffset, right.keyOffset + right.keyLength);
    }

    public static int compareVersion(BlockfileRow left, BlockfileRow right) {
        return Arrays.compareUnsigned(left.bytes, left.versionOffset, left.versionOffset + left.versionLength, right.bytes, right.versionOffset, right.versionOffset + right.versionLength);
    }

    public static int compareKeyVersionOpOptimized(BlockfileRow left, BlockfileRow right) {
        int keyDiff = BlockfileRow.compareKey(left, right);
        if (keyDiff != 0) {
            return keyDiff;
        }
        int versionDiff = BlockfileRow.compareVersion(left, right);
        if (versionDiff != 0) {
            return versionDiff;
        }
        return left.op.compareTo(right.op);
    }

    public BlockfileRowVersion toRowVersion() {
        return BlockfileRowVersionCodec.create(this.copyOfKey(), this.copyOfVersion(), this.op);
    }

    public static int totalLength(List<BlockfileRow> rows) {
        int totalLength = 0;
        int i = 0;
        while (i < rows.size()) {
            totalLength += rows.get(i).length();
            ++i;
        }
        return totalLength;
    }

    public byte[] backingBytes() {
        return this.bytes;
    }

    public byte[] copyOfBytes() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public int keyOffset() {
        return this.keyOffset;
    }

    public int keyLength() {
        return this.keyLength;
    }

    public byte[] copyOfKey() {
        return Arrays.copyOfRange(this.bytes, this.keyOffset, this.keyOffset + this.keyLength);
    }

    public int versionOffset() {
        return this.versionOffset;
    }

    public int versionLength() {
        return this.versionLength;
    }

    public byte[] copyOfVersion() {
        return Arrays.copyOfRange(this.bytes, this.versionOffset, this.versionOffset + this.versionLength);
    }

    public BlockfileRowOp op() {
        return this.op;
    }

    public int valueOffset() {
        return this.valueOffset;
    }

    public int valueLength() {
        return this.valueLength;
    }

    public byte[] copyOfValue() {
        return Arrays.copyOfRange(this.bytes, this.valueOffset, this.valueOffset + this.valueLength);
    }
}

