/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.write.listener.impl;

import io.datarouter.bytes.blockfile.block.BlockfileBlockType;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileBaseTokens;
import io.datarouter.bytes.blockfile.io.write.listener.BlockfileListener;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class BlockfileTokensListener
implements BlockfileListener {
    private final Consumer<List<BlockfileBaseTokens>> onComplete;
    private final List<BlockfileBaseTokens> blockTokens = new ArrayList<BlockfileBaseTokens>();

    public BlockfileTokensListener(Consumer<List<BlockfileBaseTokens>> onComplete) {
        this.onComplete = onComplete;
    }

    @Override
    public void accept(BlockfileBaseTokens tokens) {
        this.blockTokens.add(tokens);
    }

    public List<BlockfileBaseTokens> blockTokens() {
        return this.blockTokens;
    }

    public Scanner<BlockfileBaseTokens> scanHeaderAndValueAndIndexTokens() {
        return Scanner.of(this.blockTokens).include(tokens -> tokens.blockType() == BlockfileBlockType.HEADER || tokens.blockType() == BlockfileBlockType.VALUE || tokens.blockType() == BlockfileBlockType.INDEX);
    }

    public Optional<BlockfileBaseTokens> lastBlockTokens() {
        return this.blockTokens.isEmpty() ? Optional.empty() : Optional.of(this.blockTokens.getLast());
    }

    @Override
    public void complete() {
        this.onComplete.accept(this.blockTokens);
    }
}

