/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.write.listener.impl;

import io.datarouter.bytes.blockfile.block.BlockfileBlockType;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileBaseTokens;
import io.datarouter.bytes.blockfile.io.write.listener.BlockfileListener;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class BlockfileEndingsListener
implements BlockfileListener {
    private final Consumer<List<Long>> onComplete;
    private final List<Long> endings = new ArrayList<Long>();

    public BlockfileEndingsListener(Consumer<List<Long>> onComplete) {
        this.onComplete = onComplete;
    }

    @Override
    public void accept(BlockfileBaseTokens tokens) {
        if (BlockfileBlockType.FOOTER == tokens.blockType()) {
            return;
        }
        long length = tokens.totalLength();
        long newEnding = this.lastEnding().orElse(0L) + length;
        this.endings.add(newEnding);
    }

    public List<Long> allEndings() {
        return this.endings;
    }

    public Scanner<Long> scanAllEndings() {
        return Scanner.of(this.endings);
    }

    public Optional<Long> lastEnding() {
        return this.endings.isEmpty() ? Optional.empty() : Optional.of(this.endings.getLast());
    }

    @Override
    public void complete() {
        this.onComplete.accept(this.endings);
    }
}

