/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.write;

import io.datarouter.bytes.blockfile.block.tokens.BlockfileBaseTokens;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileIndexTokens;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileValueTokens;
import io.datarouter.bytes.blockfile.index.BlockfileByteRange;
import io.datarouter.bytes.blockfile.io.storage.BlockfileLocation;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class BlockfileWriterState {
    private final AtomicLong cursor = new AtomicLong();
    private final AtomicLong numItems = new AtomicLong();
    private final AtomicLong numGlobalBlocks = new AtomicLong();
    private final AtomicLong numValueBlocks = new AtomicLong();
    private final AtomicLong numIndexBlocks = new AtomicLong();
    private final AtomicInteger headerBlockLength = new AtomicInteger();
    private final AtomicReference<BlockfileLocation> latestIndexBlockLocation = new AtomicReference();
    private final AtomicInteger footerBlockLength = new AtomicInteger();

    public BlockfileByteRange appendHeaderBlock(BlockfileBaseTokens tokens) {
        this.takeGlobalBlockId();
        this.headerBlockLength.set(tokens.totalLength());
        return this.appendBlock(tokens);
    }

    public BlockfileByteRange appendValueBlock(BlockfileValueTokens tokens) {
        this.takeGlobalBlockId();
        BlockfileByteRange bytesBoundary = this.appendBlock(tokens);
        return bytesBoundary;
    }

    public BlockfileByteRange appendIndexBlock(BlockfileIndexTokens tokens) {
        this.takeGlobalBlockId();
        this.latestIndexBlockLocation.set(new BlockfileLocation(this.cursor.get(), tokens.totalLength()));
        return this.appendBlock(tokens);
    }

    public BlockfileByteRange appendFooterBlock(BlockfileBaseTokens tokens) {
        this.takeGlobalBlockId();
        this.footerBlockLength.set(tokens.totalLength());
        return this.appendBlock(tokens);
    }

    private BlockfileByteRange appendBlock(BlockfileBaseTokens tokens) {
        int length = tokens.totalLength();
        long cursorBefore = this.cursor.get();
        long cursorAfter = this.cursor.addAndGet(length);
        BlockfileByteRange boundary = new BlockfileByteRange(cursorBefore, cursorAfter);
        return boundary;
    }

    public long getNumItemsAndAdd(long add) {
        return this.numItems.getAndAdd(add);
    }

    public long takeGlobalBlockId() {
        return this.numGlobalBlocks.getAndIncrement();
    }

    public long previousGlobalBlockId() {
        return this.numGlobalBlocks.get() - 1L;
    }

    public long nextGlobalBlockId() {
        return this.numGlobalBlocks.get();
    }

    public BlockfileLocation headerBlockLocation() {
        return new BlockfileLocation(0L, this.headerBlockLength.get());
    }

    public long numValueBlocks() {
        return this.numValueBlocks.get();
    }

    public long takeValueBlockId() {
        return this.numValueBlocks.getAndIncrement();
    }

    public long numIndexBlocks() {
        return this.numIndexBlocks.get();
    }

    public long takeIndexBlockId() {
        return this.numIndexBlocks.getAndIncrement();
    }

    public BlockfileLocation latestIndexBlockLocation() {
        return this.latestIndexBlockLocation.get();
    }

    public void setFooterBlockLength(int length) {
        this.footerBlockLength.set(length);
    }

    public int footerBlockLength() {
        return this.footerBlockLength.get();
    }

    public long cursor() {
        return this.cursor.get();
    }
}

