/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.write;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.BlockfileGroup;
import io.datarouter.bytes.blockfile.block.decoded.BlockfileHeaderBlock;
import io.datarouter.bytes.blockfile.encoding.checksum.BlockfileChecksummer;
import io.datarouter.bytes.blockfile.encoding.checksum.BlockfileStandardChecksummers;
import io.datarouter.bytes.blockfile.encoding.compression.BlockfileCompressor;
import io.datarouter.bytes.blockfile.encoding.compression.BlockfileStandardCompressors;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockFormat;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileStandardIndexBlockFormats;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileStandardValueBlockFormats;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockFormat;
import io.datarouter.bytes.blockfile.io.write.BlockfileWriter;
import io.datarouter.bytes.blockfile.io.write.listener.BlockfileListener;
import io.datarouter.scanner.Threads;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class BlockfileWriterBuilder<T> {
    private final BlockfileGroup<T> blockfileGroup;
    private final String name;
    private BinaryDictionary headerDictionary = new BinaryDictionary();
    private Supplier<BinaryDictionary> footerDictionarySupplier = BinaryDictionary::new;
    private List<BlockfileListener> listeners = new ArrayList<BlockfileListener>();
    private int encodeBatchSize = 1;
    private Threads encodeThreads = Threads.none();
    private BlockfileValueBlockFormat valueBlockFormat = BlockfileStandardValueBlockFormats.SEQUENTIAL;
    private BlockfileIndexBlockFormat indexBlockFormat = BlockfileStandardIndexBlockFormats.V1;
    private BlockfileCompressor compressor = BlockfileStandardCompressors.NONE;
    private BlockfileChecksummer checksummer = BlockfileStandardChecksummers.NONE;
    private boolean multipartWrite = true;
    private Threads writeThreads = Threads.none();
    private Optional<ByteLength> optTargetIndexBlockSize = Optional.empty();
    private int indexFanOut = 100;

    public BlockfileWriterBuilder(BlockfileGroup<T> blockfile, String name) {
        this.blockfileGroup = blockfile;
        this.name = name;
    }

    public BlockfileWriterBuilder<T> setHeaderDictionary(BinaryDictionary headerDictionary) {
        this.headerDictionary = headerDictionary;
        return this;
    }

    public BlockfileWriterBuilder<T> setFooterDictionarySupplier(Supplier<BinaryDictionary> footerDictionarySupplier) {
        this.footerDictionarySupplier = footerDictionarySupplier;
        return this;
    }

    public BlockfileWriterBuilder<T> addListener(BlockfileListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public BlockfileWriterBuilder<T> addListeners(BlockfileListener ... listeners) {
        Arrays.asList(listeners).forEach(this::addListener);
        return this;
    }

    public BlockfileWriterBuilder<T> setEncodeBatchSize(int encodeBatchSize) {
        this.encodeBatchSize = encodeBatchSize;
        return this;
    }

    public BlockfileWriterBuilder<T> setEncodeThreads(Threads encodeThreads) {
        this.encodeThreads = encodeThreads;
        return this;
    }

    public BlockfileWriterBuilder<T> setValueBlockFormat(BlockfileValueBlockFormat format) {
        this.valueBlockFormat = format;
        return this;
    }

    public BlockfileWriterBuilder<T> setIndexBlockFormat(BlockfileIndexBlockFormat format) {
        this.indexBlockFormat = format;
        return this;
    }

    public BlockfileWriterBuilder<T> setCompressor(BlockfileCompressor compressor) {
        this.compressor = compressor;
        return this;
    }

    public BlockfileWriterBuilder<T> setChecksummer(BlockfileChecksummer checksummer) {
        this.checksummer = checksummer;
        return this;
    }

    public BlockfileWriterBuilder<T> setMultipartWrite(boolean multipartWrite) {
        this.multipartWrite = multipartWrite;
        return this;
    }

    public BlockfileWriterBuilder<T> disableMultipartWrite() {
        return this.setMultipartWrite(false);
    }

    public BlockfileWriterBuilder<T> setWriteThreads(Threads writeThreads) {
        this.writeThreads = writeThreads;
        return this;
    }

    public BlockfileWriterBuilder<T> setIndexFanOut(int indexFanOut) {
        this.indexFanOut = indexFanOut;
        return this;
    }

    public BlockfileWriterBuilder<T> setTargetIndexBlockSize(ByteLength optTargetIndexBlockSize) {
        this.optTargetIndexBlockSize = Optional.of(optTargetIndexBlockSize);
        return this;
    }

    public BlockfileWriter<T> build() {
        BlockfileHeaderBlock.BlockfileHeaderCodec headerCodec = new BlockfileHeaderBlock.BlockfileHeaderCodec(this.blockfileGroup.registeredValueBlockFormats(), this.blockfileGroup.registeredIndexBlockFormats(), this.blockfileGroup.registeredCompressors(), this.blockfileGroup.registeredChecksummers());
        BlockfileWriter.BlockfileWriterConfig config = new BlockfileWriter.BlockfileWriterConfig(this.blockfileGroup.storage(), headerCodec, this.valueBlockFormat, this.indexBlockFormat, this.compressor, this.checksummer, this.headerDictionary, this.footerDictionarySupplier, this.listeners, this.encodeBatchSize, this.encodeThreads, this.multipartWrite, this.writeThreads, this.indexFanOut, this.optTargetIndexBlockSize);
        return new BlockfileWriter(config, this.name);
    }
}

