/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.write;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.index.BlockfileIndexBlockInput;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BlockfileIndexBlockBuilder {
    private final int maxRecordsPerLevel;
    private final Optional<ByteLength> optTargetBlockSize;
    private final int level;
    private final List<BlockfileIndexEntry> children = new ArrayList<BlockfileIndexEntry>();
    private long estEncodedSize;

    public BlockfileIndexBlockBuilder(int maxRecordsPerLevel, Optional<ByteLength> optTargetBlockSize, int level) {
        this.maxRecordsPerLevel = maxRecordsPerLevel;
        this.optTargetBlockSize = optTargetBlockSize;
        this.level = level;
        this.estEncodedSize = 0L;
    }

    public void addChild(BlockfileIndexEntry child, int addToEstEncodedSize) {
        this.children.add(child);
        this.estEncodedSize += (long)addToEstEncodedSize;
    }

    public int numChildren() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public long estEncodedSize() {
        return this.estEncodedSize;
    }

    public boolean isFull() {
        if (this.optTargetBlockSize.isPresent() && this.estEncodedSize >= this.optTargetBlockSize.orElseThrow().toBytes()) {
            return true;
        }
        return this.children.size() >= this.maxRecordsPerLevel;
    }

    public int level() {
        return this.level;
    }

    public BlockfileIndexBlockInput build(long globalBlockId, long indexBlockId) {
        return new BlockfileIndexBlockInput(globalBlockId, indexBlockId, this.level, this.children);
    }
}

