/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.storage;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.io.storage.BlockfileLocation;
import io.datarouter.bytes.blockfile.io.storage.BlockfileNameAndSize;
import io.datarouter.bytes.blockfile.io.storage.BlockfileSegment;
import io.datarouter.bytes.io.MultiByteArrayInputStream;
import io.datarouter.bytes.split.ChunkScannerTool;
import io.datarouter.scanner.Threads;
import java.io.InputStream;
import java.util.List;

public interface BlockfileStorage {
    public List<BlockfileNameAndSize> list();

    public long length(String var1);

    public byte[] read(String var1);

    public byte[] readPartial(String var1, BlockfileLocation var2);

    default public BlockfileSegment readSegment(String name, BlockfileLocation location) {
        return new BlockfileSegment(name, location.from(), this.readPartial(name, location));
    }

    public byte[] readEnding(String var1, int var2);

    public InputStream readInputStream(String var1, Threads var2, ByteLength var3);

    default public InputStream readInputStream(String name, long from, long to, Threads threads, ByteLength chunkSize) {
        return (InputStream)ChunkScannerTool.scanChunks(from, to, chunkSize.toBytesInt()).parallelOrdered(threads).map(chunkRange -> this.readPartial(name, new BlockfileLocation(chunkRange.start, chunkRange.length))).apply(MultiByteArrayInputStream::new);
    }

    public void write(String var1, byte[] var2);

    public void write(String var1, InputStream var2, Threads var3);

    public void deleteMulti(List<String> var1);
}

