/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.storage;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.varint.VarIntTool;

public record BlockfileLocation(long from, int length) {
    public static final Codec<BlockfileLocation, byte[]> CODEC = Codec.of(BlockfileLocation::encodeVarInt, BlockfileLocation::decodeVarInt);

    public long to() {
        return this.from + (long)this.length;
    }

    private static byte[] encodeVarInt(BlockfileLocation location) {
        return ByteTool.concat(VarIntTool.encode(location.from()), VarIntTool.encode(location.length()));
    }

    private static BlockfileLocation decodeVarInt(byte[] bytes) {
        int cursor = 0;
        long from = VarIntTool.decodeLong(bytes, cursor);
        int length = VarIntTool.decodeInt(bytes, cursor += VarIntTool.length(from));
        cursor += VarIntTool.length(length);
        return new BlockfileLocation(from, length);
    }
}

