/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.read.query;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.blockfile.block.decoded.BlockfileIndexBlock;
import io.datarouter.bytes.blockfile.block.parsed.BlockfileDecodedBlock;
import io.datarouter.bytes.blockfile.block.parsed.BlockfileDecodedBlockBatch;
import io.datarouter.bytes.blockfile.block.parsed.ParsedValueBlock;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockCodec;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntry;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntryRange;
import io.datarouter.bytes.blockfile.io.read.BlockfileReader;
import io.datarouter.bytes.blockfile.io.read.query.BlockfileSequentialReader;
import io.datarouter.bytes.blockfile.row.BlockfileRow;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockfileRowKeyRangeReader<T> {
    private static final Logger logger = LoggerFactory.getLogger(BlockfileRowKeyRangeReader.class);
    private final BlockfileReader<T> reader;
    private final BlockfileSequentialReader<T> sequentialReader;
    private final BlockfileIndexBlockCodec indexBlockCodec;

    public BlockfileRowKeyRangeReader(BlockfileReader<T> reader) {
        this.reader = reader;
        this.sequentialReader = new BlockfileSequentialReader<T>(reader);
        this.indexBlockCodec = reader.metadata().header().indexBlockFormat().supplier().get();
    }

    public BlockfileIndexEntryRange indexEntryRange(BlockfileKeyRange range) {
        BlockfileIndexBlock rootIndexBlock = this.reader.metadata().rootIndex();
        int level = rootIndexBlock.level();
        BlockfileIndexBlock firstIndexBlock = rootIndexBlock;
        BlockfileIndexBlock lastIndexBlock = rootIndexBlock;
        BlockfileIndexEntry firstIndexEntry = null;
        BlockfileIndexEntry lastIndexEntry = null;
        while (true) {
            int firstIndexEntryIndex = 0;
            if (range.from().isPresent()) {
                firstIndexEntryIndex = this.indexBlockCodec.rangeStartIndex(firstIndexBlock, range.from().orElseThrow());
            }
            firstIndexEntry = this.indexBlockCodec.decodeChild(lastIndexBlock, firstIndexEntryIndex);
            int lastIndexEntryIndex = lastIndexBlock.numChildren() - 1;
            if (range.to().isPresent()) {
                lastIndexEntryIndex = this.indexBlockCodec.rangeEndIndex(lastIndexBlock, range.to().orElseThrow());
            }
            lastIndexEntry = this.indexBlockCodec.decodeChild(lastIndexBlock, lastIndexEntryIndex);
            if (level == 0) break;
            firstIndexBlock = this.reader.loadIndexBlock(firstIndexEntry);
            boolean sameChildBlock = firstIndexEntry.childGlobalBlockId() == lastIndexEntry.childGlobalBlockId();
            lastIndexBlock = sameChildBlock ? firstIndexBlock : this.reader.loadIndexBlock(lastIndexEntry);
            --level;
        }
        return new BlockfileIndexEntryRange(firstIndexEntry, lastIndexEntry);
    }

    public Scanner<T> scanRange(BlockfileKeyRange keyRange) {
        BlockfileKeyRange inclusiveExclusiveRange = keyRange.toInclusiveExclusive();
        BlockfileIndexEntryRange indexEntryRange = this.indexEntryRange(inclusiveExclusiveRange);
        return this.sequentialReader.scanParsedValueBlocks(indexEntryRange, inclusiveExclusiveRange).batch(this.reader.config().decodeBatchSize()).parallelOrdered(this.reader.config().decodeThreads()).map(block -> this.reader.valueBlockDecoder().decompressAndDecodeValueBlocks((List<ParsedValueBlock>)block, inclusiveExclusiveRange)).concatIter(BlockfileDecodedBlockBatch::blocks).concatIter(BlockfileDecodedBlock::items);
    }

    public record BlockfileKeyRange(Optional<byte[]> from, boolean fromInclusive, Optional<byte[]> to, boolean toInclusive) {
        private static final BlockfileKeyRange EVERYTHING = new BlockfileKeyRange(Optional.empty(), true, Optional.empty(), true);

        public static BlockfileKeyRange everything() {
            return EVERYTHING;
        }

        public boolean isEverything() {
            return this.from.isEmpty() && this.to.isEmpty();
        }

        public BlockfileKeyRange toInclusiveExclusive() {
            return new BlockfileKeyRange(this.from.map(fromBytes -> this.fromInclusive ? fromBytes : ByteTool.unsignedIncrement(fromBytes)), true, this.to.map(toBytes -> this.toInclusive ? ByteTool.unsignedIncrement(toBytes) : toBytes), false);
        }

        public boolean contains(BlockfileRow row) {
            boolean firstMatch = this.from.isEmpty();
            if (this.from.isPresent()) {
                int diff = row.compareToKey(this.from.orElseThrow());
                firstMatch = this.fromInclusive ? diff >= 0 : diff > 0;
            }
            boolean lastMatch = this.to.isEmpty();
            if (this.to.isPresent()) {
                int diff = row.compareToKey(this.to.orElseThrow());
                boolean bl = this.toInclusive ? diff <= 0 : (lastMatch = diff < 0);
            }
            return firstMatch && lastMatch;
        }
    }
}

