/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.read.metadata;

import io.datarouter.bytes.blockfile.BlockfileGroup;
import io.datarouter.bytes.blockfile.block.decoded.BlockfileHeaderBlock;
import io.datarouter.bytes.blockfile.io.read.metadata.BlockfileMetadataReader;
import java.util.Optional;

public class BlockfileMetadataReaderBuilder<T> {
    private final BlockfileGroup<T> blockfileGroup;
    private final String name;
    private Optional<Long> knownFileLength = Optional.empty();

    public BlockfileMetadataReaderBuilder(BlockfileGroup<T> blockfile, String name) {
        this.blockfileGroup = blockfile;
        this.name = name;
    }

    public BlockfileMetadataReaderBuilder<T> setKnownFileLength(long knownFileLength) {
        this.knownFileLength = Optional.of(knownFileLength);
        return this;
    }

    public BlockfileMetadataReader<T> build() {
        BlockfileHeaderBlock.BlockfileHeaderCodec headerCodec = new BlockfileHeaderBlock.BlockfileHeaderCodec(this.blockfileGroup.registeredValueBlockFormats(), this.blockfileGroup.registeredIndexBlockFormats(), this.blockfileGroup.registeredCompressors(), this.blockfileGroup.registeredChecksummers());
        BlockfileMetadataReader.BlockfileMetadataReaderConfig config = new BlockfileMetadataReader.BlockfileMetadataReaderConfig(this.blockfileGroup.storage(), headerCodec, this.knownFileLength);
        return new BlockfileMetadataReader(config, this.name);
    }
}

