/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.read;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.BlockfileGroup;
import io.datarouter.bytes.blockfile.block.decoded.BlockfileHeaderBlock;
import io.datarouter.bytes.blockfile.io.read.BlockfileReader;
import io.datarouter.bytes.blockfile.io.read.metadata.BlockfileMetadataReader;
import io.datarouter.bytes.blockfile.row.BlockfileRow;
import io.datarouter.scanner.Threads;
import java.util.Optional;
import java.util.function.Function;

public class BlockfileReaderBuilder<T> {
    private final BlockfileGroup<T> blockfileGroup;
    private final BlockfileMetadataReader<T> metadataReader;
    private final Function<BlockfileRow, T> rowDecoder;
    private Threads readThreads = Threads.none();
    private ByteLength readChunkSize = ByteLength.ofMiB(4L);
    private int decodeBatchSize = 1;
    private Threads decodeThreads = Threads.none();
    private boolean validateChecksums = false;
    private Optional<Long> knownFileLength = Optional.empty();

    public BlockfileReaderBuilder(BlockfileGroup<T> blockfile, BlockfileMetadataReader<T> metadataReader, Function<BlockfileRow, T> rowDecoder) {
        this.blockfileGroup = blockfile;
        this.metadataReader = metadataReader;
        this.rowDecoder = rowDecoder;
    }

    public BlockfileReaderBuilder<T> setReadThreads(Threads readThreads) {
        this.readThreads = readThreads;
        return this;
    }

    public BlockfileReaderBuilder<T> setReadChunkSize(ByteLength readChunkSize) {
        this.readChunkSize = readChunkSize;
        return this;
    }

    public BlockfileReaderBuilder<T> setDecodeBatchSize(int decodeBatchSize) {
        this.decodeBatchSize = decodeBatchSize;
        return this;
    }

    public BlockfileReaderBuilder<T> setDecodeThreads(Threads decodeThreads) {
        this.decodeThreads = decodeThreads;
        return this;
    }

    public BlockfileReaderBuilder<T> enableChecksumValidation() {
        this.validateChecksums = true;
        return this;
    }

    public BlockfileReader<T> build() {
        BlockfileHeaderBlock.BlockfileHeaderCodec headerCodec = new BlockfileHeaderBlock.BlockfileHeaderCodec(this.blockfileGroup.registeredValueBlockFormats(), this.blockfileGroup.registeredIndexBlockFormats(), this.blockfileGroup.registeredCompressors(), this.blockfileGroup.registeredChecksummers());
        BlockfileReader.BlockfileReaderConfig<T> config = new BlockfileReader.BlockfileReaderConfig<T>(this.blockfileGroup.storage(), this.rowDecoder, headerCodec, this.readThreads, this.readChunkSize, this.decodeBatchSize, this.decodeThreads, this.validateChecksums, this.knownFileLength);
        return new BlockfileReader<T>(this.metadataReader, config);
    }
}

