/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.read;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.block.decoded.BlockfileHeaderBlock;
import io.datarouter.bytes.blockfile.block.decoded.BlockfileIndexBlock;
import io.datarouter.bytes.blockfile.block.parsed.BlockfileDecodedBlock;
import io.datarouter.bytes.blockfile.block.parsed.BlockfileDecodedBlockBatch;
import io.datarouter.bytes.blockfile.block.parsed.ParsedValueBlock;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileBaseTokens;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockCodec;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockDecoder;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntry;
import io.datarouter.bytes.blockfile.io.read.metadata.BlockfileMetadataReader;
import io.datarouter.bytes.blockfile.io.read.query.BlockfileBlockIdReader;
import io.datarouter.bytes.blockfile.io.read.query.BlockfileIndexReader;
import io.datarouter.bytes.blockfile.io.read.query.BlockfileRowIdReader;
import io.datarouter.bytes.blockfile.io.read.query.BlockfileRowKeyRangeReader;
import io.datarouter.bytes.blockfile.io.read.query.BlockfileRowKeyReader;
import io.datarouter.bytes.blockfile.io.read.query.BlockfileSequentialReader;
import io.datarouter.bytes.blockfile.io.storage.BlockfileLocation;
import io.datarouter.bytes.blockfile.io.storage.BlockfileStorage;
import io.datarouter.bytes.blockfile.row.BlockfileRow;
import io.datarouter.scanner.Threads;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class BlockfileReader<T> {
    private final BlockfileMetadataReader<T> metadata;
    private final BlockfileReaderConfig<T> config;
    private final BlockfileValueBlockDecoder<T> valueBlockDecoder;

    public BlockfileReader(BlockfileMetadataReader<T> metadata, BlockfileReaderConfig<T> config) {
        this.metadata = metadata;
        this.config = config;
        BlockfileValueBlockDecoder.BlockfileValueBlockDecoderConfig<T> decodingManagerConfig = new BlockfileValueBlockDecoder.BlockfileValueBlockDecoderConfig<T>(config.rowDecoder(), metadata, config.validateChecksums());
        this.valueBlockDecoder = new BlockfileValueBlockDecoder<T>(decodingManagerConfig);
    }

    public BlockfileMetadataReader<T> metadata() {
        return this.metadata;
    }

    public BlockfileReaderConfig<T> config() {
        return this.config;
    }

    public BlockfileValueBlockDecoder<T> valueBlockDecoder() {
        return this.valueBlockDecoder;
    }

    public BlockfileSequentialReader<T> sequential() {
        return new BlockfileSequentialReader(this);
    }

    public BlockfileIndexReader<T> index() {
        return new BlockfileIndexReader(this);
    }

    public BlockfileBlockIdReader<T> blockId() {
        return new BlockfileBlockIdReader(this);
    }

    public BlockfileRowIdReader<T> rowId() {
        return new BlockfileRowIdReader(this);
    }

    public BlockfileRowKeyReader<T> rowKey() {
        return new BlockfileRowKeyReader(this);
    }

    public BlockfileRowKeyRangeReader<T> rowKeyRange() {
        return new BlockfileRowKeyRangeReader(this);
    }

    public BlockfileIndexBlock loadIndexBlock(BlockfileIndexEntry indexEntry) {
        byte[] bytes = this.config().storage().readPartial(this.metadata().name(), indexEntry.byteRange().toLocation());
        return this.metadata().header().indexBlockFormat().supplier().get().decode(bytes);
    }

    public BlockfileValueBlockCodec.BlockfileEncodedValueBlock loadEncodedValueBlock(BlockfileIndexEntry index) {
        ParsedValueBlock parsedValueBlock = this.loadParsedValueBlock(index.byteRange().toLocation());
        return this.valueBlockDecoder.decompressValueBlock(parsedValueBlock);
    }

    public BlockfileDecodedBlock<T> loadValueBlock(BlockfileLocation location) {
        ParsedValueBlock parsed = this.loadParsedValueBlock(location);
        BlockfileDecodedBlockBatch<T> blockBatch = this.valueBlockDecoder.decompressAndDecodeValueBlocks(List.of(parsed));
        return blockBatch.blocks().getFirst();
    }

    private ParsedValueBlock loadParsedValueBlock(BlockfileLocation location) {
        byte[] bytes = this.config().storage().readPartial(this.metadata().name(), location);
        int cursor = 0;
        byte[] lengthBytes = Arrays.copyOfRange(bytes, cursor, BlockfileBaseTokens.NUM_LENGTH_BYTES);
        cursor += BlockfileBaseTokens.NUM_LENGTH_BYTES;
        byte[] checksumBytes = Arrays.copyOfRange(bytes, ++cursor, cursor + this.metadata().header().checksummer().numBytes());
        byte[] compressedValueBytes = Arrays.copyOfRange(bytes, cursor += this.metadata().header().checksummer().numBytes(), bytes.length);
        return new ParsedValueBlock(lengthBytes, checksumBytes, compressedValueBytes);
    }

    public InputStream makeInputStream() {
        if (this.config().knownFileLength().isPresent() && this.config().knownFileLength().orElseThrow() <= this.config().readChunkSize().toBytes()) {
            return new ByteArrayInputStream(this.config().storage().read(this.metadata().name()));
        }
        return this.config().storage().readInputStream(this.metadata().name(), this.config().readThreads(), this.config().readChunkSize());
    }

    public InputStream makeInputStream(long from, long to) {
        long length = to - from;
        if (length <= this.config().readChunkSize().toBytes()) {
            return new ByteArrayInputStream(this.config().storage().readPartial(this.metadata().name(), new BlockfileLocation(from, (int)length)));
        }
        return this.config().storage().readInputStream(this.metadata().name(), from, to, this.config().readThreads(), this.config().readChunkSize());
    }

    public record BlockfileReaderConfig<T>(BlockfileStorage storage, Function<BlockfileRow, T> rowDecoder, BlockfileHeaderBlock.BlockfileHeaderCodec headerCodec, Threads readThreads, ByteLength readChunkSize, int decodeBatchSize, Threads decodeThreads, boolean validateChecksums, Optional<Long> knownFileLength) {
    }
}

