/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.compact;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.io.compact.BlockfileCompactorFileCache;
import io.datarouter.bytes.blockfile.io.merge.BlockfileMergePlan;
import io.datarouter.bytes.blockfile.io.merge.BlockfileMerger;
import io.datarouter.bytes.blockfile.io.merge.BlockfileMergerParams;
import io.datarouter.bytes.blockfile.io.storage.BlockfileNameAndSize;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockfileCompactor {
    private static final Logger logger = LoggerFactory.getLogger(BlockfileCompactor.class);
    private final BlockfileCompactorParams params;
    private final BlockfileCompactorFileCache fileCache;

    public BlockfileCompactor(BlockfileCompactorParams params) {
        this.params = params;
        this.fileCache = new BlockfileCompactorFileCache(params.targetNumFiles(), params.prune(), params.mergerParams().readParams().readBufferSize(), params.mergerParams().readParams().memoryFanIn(), params.mergerParams().readParams().streamingFanIn(), this.listFilesInDirectory());
    }

    public void compact() {
        Scanner.generate(this.fileCache::findNextMergePlan).advanceWhile(Optional::isPresent).map(Optional::orElseThrow).forEach(this::merge);
    }

    private void merge(BlockfileMergePlan plan) {
        logger.warn("startingMerging {}/{}->{}, inputSize={}, files={}", new Object[]{plan.files().size(), this.fileCache.numFiles(), this.fileCache.numFiles() - plan.files().size() + 1, BlockfileNameAndSize.totalSize(plan.files()).toDisplay(), BlockfileCompactor.makeFileSummaryMessage(plan.files())});
        BlockfileMerger merger = new BlockfileMerger(this.params.mergerParams(), plan, ((Supplier<Boolean>)this.params.shouldStop())::get);
        BlockfileNameAndSize newFile = merger.merge();
        this.fileCache.add(newFile);
        Scanner.of(plan.files()).each(this.fileCache::remove).map(BlockfileNameAndSize::name).batch(1000).forEach(this.params.mergerParams().storageParams().blockfileGroup().storage()::deleteMulti);
    }

    private List<BlockfileNameAndSize> listFilesInDirectory() {
        return this.params.mergerParams().storageParams().blockfileGroup().storage().list();
    }

    private void validateFileCacheSize() {
        int numFilesInDirectory = this.listFilesInDirectory().size();
        if (this.fileCache.numFiles() != numFilesInDirectory) {
            String message = String.format("fileCacheSize=%s != filesInDirectory=%s", this.fileCache.numFiles(), numFilesInDirectory);
            throw new IllegalStateException(message);
        }
    }

    private static String makeFileSummaryMessage(List<BlockfileNameAndSize> files) {
        return (String)Scanner.of(files).map(file -> String.format("%s[%s]", file.name(), ByteLength.ofBytes(file.size()).toDisplay())).collect(Collectors.joining(", "));
    }

    public record BlockfileCompactorParams(Supplier<Boolean> shouldStop, int targetNumFiles, boolean prune, BlockfileMergerParams mergerParams) {
    }
}

