/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.index;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class BlockfilePointSearchTool {
    public static <C, I> int binarySearch(int size, Function<Integer, I> extractFn, Function<I, Integer> compareFn, BlockfileBinarySearchType searchType) {
        int low = 0;
        int high = size - 1;
        int mid = 0;
        int comp = 0;
        Integer resultIndex = null;
        while (low <= high) {
            mid = low + (high - low) / 2;
            I item = extractFn.apply(mid);
            comp = compareFn.apply(item);
            if (comp < 0) {
                low = mid + 1;
                continue;
            }
            if (comp == 0) {
                resultIndex = mid;
                if (searchType == BlockfileBinarySearchType.ANY) {
                    return mid;
                }
                if (searchType == BlockfileBinarySearchType.FIRST) {
                    high = mid - 1;
                    continue;
                }
                if (searchType != BlockfileBinarySearchType.LAST) continue;
                low = mid + 1;
                continue;
            }
            if (comp <= 0) continue;
            high = mid - 1;
        }
        return resultIndex != null ? resultIndex : -mid - 1;
    }

    public static <C, I> Optional<I> find(int size, Function<Integer, I> extractFn, Function<I, Integer> compareFn, BlockfileBinarySearchType searchType) {
        int index = BlockfilePointSearchTool.binarySearch(size, extractFn, compareFn, searchType);
        return index < 0 ? Optional.empty() : Optional.of(extractFn.apply(index));
    }

    public static <C, I, K> Optional<I> find(C items, int size, BiFunction<C, Integer, I> extractBiFn, BiFunction<I, K, Integer> compareBiFn, K searchKey, BlockfileBinarySearchType searchType) {
        Function<Integer, Object> extractFn = index -> extractBiFn.apply(items, (Integer)index);
        Function<Object, Integer> compareFn = item -> (Integer)compareBiFn.apply(item, searchKey);
        return BlockfilePointSearchTool.find(size, extractFn, compareFn, searchType);
    }

    public static <I, K> Optional<I> findInList(List<I> items, BiFunction<I, K, Integer> compareBiFn, K searchKey, BlockfileBinarySearchType searchType) {
        Function<Integer, Object> extractFn = index -> items.get((int)index);
        Function<Object, Integer> compareFn = item -> (Integer)compareBiFn.apply(item, searchKey);
        return BlockfilePointSearchTool.find(items.size(), extractFn, compareFn, searchType);
    }

    public static <C, I> Optional<I> findAny(int size, Function<Integer, I> extractFn, Function<I, Integer> compareFn) {
        return BlockfilePointSearchTool.find(size, extractFn, compareFn, BlockfileBinarySearchType.ANY);
    }

    public static <C, I, K> Optional<I> findAny(C items, int size, BiFunction<C, Integer, I> extractBiFn, BiFunction<I, K, Integer> compareBiFn, K searchKey) {
        return BlockfilePointSearchTool.find(items, size, extractBiFn, compareBiFn, searchKey, BlockfileBinarySearchType.ANY);
    }

    public static <I, K> Optional<I> findAnyInList(List<I> items, BiFunction<I, K, Integer> compareBiFn, K searchKey) {
        return BlockfilePointSearchTool.findInList(items, compareBiFn, searchKey, BlockfileBinarySearchType.ANY);
    }

    public static <C, I> Optional<I> findFirst(int size, Function<Integer, I> extractFn, Function<I, Integer> compareFn) {
        return BlockfilePointSearchTool.find(size, extractFn, compareFn, BlockfileBinarySearchType.FIRST);
    }

    public static <C, I, K> Optional<I> findFirst(C items, int size, BiFunction<C, Integer, I> extractBiFn, BiFunction<I, K, Integer> compareBiFn, K searchKey) {
        return BlockfilePointSearchTool.find(items, size, extractBiFn, compareBiFn, searchKey, BlockfileBinarySearchType.FIRST);
    }

    public static <I, K> Optional<I> findFirstInList(List<I> items, BiFunction<I, K, Integer> compareBiFn, K searchKey) {
        return BlockfilePointSearchTool.findInList(items, compareBiFn, searchKey, BlockfileBinarySearchType.FIRST);
    }

    public static <C, I> Optional<I> findLast(int size, Function<Integer, I> extractFn, Function<I, Integer> compareFn) {
        return BlockfilePointSearchTool.find(size, extractFn, compareFn, BlockfileBinarySearchType.LAST);
    }

    public static <C, I, K> Optional<I> findLast(C items, int size, BiFunction<C, Integer, I> extractBiFn, BiFunction<I, K, Integer> compareBiFn, K searchKey) {
        return BlockfilePointSearchTool.find(items, size, extractBiFn, compareBiFn, searchKey, BlockfileBinarySearchType.LAST);
    }

    public static <I, K> Optional<I> findLastInList(List<I> items, BiFunction<I, K, Integer> compareBiFn, K searchKey) {
        return BlockfilePointSearchTool.findInList(items, compareBiFn, searchKey, BlockfileBinarySearchType.LAST);
    }

    public static enum BlockfileBinarySearchType {
        ANY,
        FIRST,
        LAST;

    }
}

