/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.encoding.valueblock;

import io.datarouter.bytes.blockfile.block.tokens.BlockfileValueTokens;
import io.datarouter.bytes.blockfile.encoding.checksum.BlockfileChecksummer;
import io.datarouter.bytes.blockfile.encoding.compression.BlockfileCompressor;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockCodec;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockFormat;
import io.datarouter.bytes.blockfile.row.BlockfileRow;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class BlockfileValueBlockEncoder {
    private final BlockfileValueBlockEncoderConfig config;
    private final BlockfileValueBlockCodec valueBlockCodec;

    public BlockfileValueBlockEncoder(BlockfileValueBlockEncoderConfig config) {
        this.config = config;
        this.valueBlockCodec = config.valueBlockFormat().supplier().get();
    }

    public List<BlockfileValueTokens> encodeValueBlocks(List<BlockfileValueBlockCodec.BlockfileValueBlockRows> blocks) {
        Function<byte[], byte[]> compressFunction = this.config.compressor().newEncoder();
        Function<byte[], byte[]> checksumFunction = this.config.checksummer().newEncoder();
        return (List)Scanner.of(blocks).map(block -> this.encodeValueBlock(compressFunction, checksumFunction, (BlockfileValueBlockCodec.BlockfileValueBlockRows)block)).collect(() -> new ArrayList(blocks.size()));
    }

    private BlockfileValueTokens encodeValueBlock(Function<byte[], byte[]> compressFunction, Function<byte[], byte[]> checksumFunction, BlockfileValueBlockCodec.BlockfileValueBlockRows blockRows) {
        List<BlockfileRow> rows = blockRows.rows();
        byte[] encodedBytes = this.valueBlockCodec.encode(blockRows).bytes();
        byte[] compressedBytes = compressFunction.apply(encodedBytes);
        int nonValueLength = BlockfileValueTokens.lengthWithoutValue(this.config.checksummer().numBytes());
        int blockLength = nonValueLength + compressedBytes.length;
        byte[] checksumBytes = checksumFunction.apply(compressedBytes);
        return new BlockfileValueTokens(blockRows.valueBlockId(), blockRows.firstRowIdInBlock(), rows, blockLength, checksumBytes, compressedBytes);
    }

    public record BlockfileValueBlockEncoderConfig(BlockfileValueBlockFormat valueBlockFormat, BlockfileCompressor compressor, BlockfileChecksummer checksummer) {
    }
}

