/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.encoding.valueblock;

import io.datarouter.bytes.blockfile.block.parsed.BlockfileDecodedBlock;
import io.datarouter.bytes.blockfile.block.parsed.BlockfileDecodedBlockBatch;
import io.datarouter.bytes.blockfile.block.parsed.ParsedValueBlock;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileValueTokens;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockCodec;
import io.datarouter.bytes.blockfile.io.read.metadata.BlockfileMetadataReader;
import io.datarouter.bytes.blockfile.io.read.query.BlockfileRowKeyRangeReader;
import io.datarouter.bytes.blockfile.row.BlockfileRow;
import io.datarouter.bytes.codec.bytestringcodec.HexByteStringCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class BlockfileValueBlockDecoder<T> {
    private final BlockfileValueBlockDecoderConfig<T> config;
    private final BlockfileMetadataReader<T> metadata;

    public BlockfileValueBlockDecoder(BlockfileValueBlockDecoderConfig<T> config) {
        this.config = config;
        this.metadata = config.metadata();
    }

    public List<byte[]> decompressValueBlocks(List<ParsedValueBlock> parsedValueBlocks) {
        Function<byte[], byte[]> decompressor = this.metadata.header().compressor().newDecoder();
        ArrayList<byte[]> decompressedByteArrays = new ArrayList<byte[]>(parsedValueBlocks.size());
        for (ParsedValueBlock parsedValueBlock : parsedValueBlocks) {
            if (this.config.validateChecksums()) {
                this.validateChecksum(parsedValueBlock);
            }
            byte[] decompressedBytes = decompressor.apply(parsedValueBlock.compressedValue());
            decompressedByteArrays.add(decompressedBytes);
        }
        return decompressedByteArrays;
    }

    public BlockfileValueBlockCodec.BlockfileEncodedValueBlock decompressValueBlock(ParsedValueBlock parsedValueBlock) {
        if (this.config.validateChecksums()) {
            this.validateChecksum(parsedValueBlock);
        }
        Function<byte[], byte[]> decompressor = this.metadata.header().compressor().newDecoder();
        byte[] decompressedBytes = decompressor.apply(parsedValueBlock.compressedValue());
        return new BlockfileValueBlockCodec.BlockfileEncodedValueBlock(decompressedBytes);
    }

    public BlockfileDecodedBlockBatch<T> decompressAndDecodeValueBlocks(List<ParsedValueBlock> parsedValueBlocks) {
        return this.decompressAndDecodeValueBlocks(parsedValueBlocks, BlockfileRowKeyRangeReader.BlockfileKeyRange.everything());
    }

    public BlockfileDecodedBlockBatch<T> decompressAndDecodeValueBlocks(List<ParsedValueBlock> parsedValueBlocks, BlockfileRowKeyRangeReader.BlockfileKeyRange keyRange) {
        Function<byte[], byte[]> decompressor = this.metadata.header().compressor().newDecoder();
        BlockfileValueBlockCodec valueBlockCodec = this.metadata.header().valueBlockFormat().newCodec();
        int numMetadataBytes = BlockfileValueTokens.lengthWithoutValue(this.metadata.header().checksummer().numBytes());
        ArrayList decodedBlocks = new ArrayList(parsedValueBlocks.size());
        long totalCompressedSize = 0L;
        long totalDecompressedSize = 0L;
        for (ParsedValueBlock parsedValueBlock : parsedValueBlocks) {
            if (this.config.validateChecksums()) {
                this.validateChecksum(parsedValueBlock);
            }
            byte[] decompressedBytes = decompressor.apply(parsedValueBlock.compressedValue());
            BlockfileValueBlockCodec.BlockfileEncodedValueBlock encodedValue = new BlockfileValueBlockCodec.BlockfileEncodedValueBlock(decompressedBytes);
            BlockfileValueBlockCodec.BlockfileValueBlockRows rows = valueBlockCodec.decode(encodedValue, keyRange);
            List<T> items = this.decodeRows(rows.rows());
            BlockfileDecodedBlock<T> decodedBlock = new BlockfileDecodedBlock<T>(numMetadataBytes + parsedValueBlock.compressedValue().length, numMetadataBytes + decompressedBytes.length, rows.firstRowIdInBlock(), items);
            decodedBlocks.add(decodedBlock);
            totalCompressedSize += (long)parsedValueBlock.compressedValue().length;
            totalDecompressedSize += (long)decompressedBytes.length;
        }
        return new BlockfileDecodedBlockBatch(totalCompressedSize, totalDecompressedSize, decodedBlocks);
    }

    private List<T> decodeRows(List<BlockfileRow> rows) {
        Function<BlockfileRow, BlockfileRow> rowDecoder = this.config.rowDecoder();
        if (Function.identity().equals(rowDecoder)) {
            return rows;
        }
        ArrayList<T> items = new ArrayList<T>(rows.size());
        for (BlockfileRow row : rows) {
            items.add(rowDecoder.apply(row));
        }
        return items;
    }

    private void validateChecksum(ParsedValueBlock parsedValueBlock) {
        byte[] actual;
        Function<byte[], byte[]> encoder = this.metadata.header().checksummer().newEncoder();
        byte[] expected = parsedValueBlock.checksum();
        if (!Arrays.equals(expected, actual = encoder.apply(parsedValueBlock.compressedValue()))) {
            String message = String.format("invalid checksum: expected=%s, actual=%s", HexByteStringCodec.INSTANCE.encode(expected), HexByteStringCodec.INSTANCE.encode(actual));
            throw new RuntimeException(message);
        }
    }

    public record BlockfileValueBlockDecoderConfig<T>(Function<BlockfileRow, T> rowDecoder, BlockfileMetadataReader<T> metadata, boolean validateChecksums) {
    }
}

