/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.encoding.indexblock.impl;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.blockfile.block.decoded.BlockfileIndexBlock;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileBaseTokens;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileIndexTokens;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockCodec;
import io.datarouter.bytes.blockfile.index.BlockfileByteRange;
import io.datarouter.bytes.blockfile.index.BlockfileIndexBlockInput;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntry;
import io.datarouter.bytes.blockfile.index.BlockfileRowIdRange;
import io.datarouter.bytes.blockfile.index.BlockfileRowRange;
import io.datarouter.bytes.blockfile.index.BlockfileValueBlockIdRange;
import io.datarouter.bytes.blockfile.row.BlockfileRowVersionCodec;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import io.datarouter.bytes.codec.longcodec.RawLongCodec;
import io.datarouter.bytes.varint.VarIntTool;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockfileV1IndexBlockCodec
implements BlockfileIndexBlockCodec {
    private static final Logger logger = LoggerFactory.getLogger(BlockfileV1IndexBlockCodec.class);

    @Override
    public int estEncodedBytes(BlockfileIndexEntry indexEntry) {
        return 4 + BlockfileIndexOffsetsTableRow.ROW_LENGTH + indexEntry.rowRange().sumOfLengths();
    }

    @Override
    public BlockfileIndexTokens encode(BlockfileIndexBlockInput input) {
        List<BlockfileIndexEntry> children = input.children();
        List rowKeyTokens = (List)Scanner.of(children).map(BlockfileIndexEntry::rowRange).map(BlockfileV1IndexBlockCodec::encodeRowRange).collect(() -> new ArrayList(children.size()));
        ArrayList<byte[]> tokens = new ArrayList<byte[]>();
        tokens.add(VarIntTool.encode(input.globalBlockId()));
        tokens.add(VarIntTool.encode(input.indexBlockId()));
        tokens.add(VarIntTool.encode(input.level()));
        tokens.add(VarIntTool.encode(children.size()));
        int indexOffset = 0;
        int i = 0;
        while (i < children.size()) {
            BlockfileIndexEntry child = children.get(i);
            BlockfileIndexOffsetsTableRow offsetsTableRow = new BlockfileIndexOffsetsTableRow(child.childGlobalBlockId(), child.childIndexOrValueBlockId(), child.valueBlockIdRange().first(), child.valueBlockIdRange().last(), child.rowIdRange().first(), child.rowIdRange().last(), child.byteRange().from(), child.byteRange().lengthInt(), indexOffset);
            tokens.add(offsetsTableRow.encode());
            indexOffset += ((byte[])rowKeyTokens.get(i)).length;
            ++i;
        }
        tokens.addAll(rowKeyTokens);
        byte[] valueBytes = ByteTool.concat(tokens);
        int length = BlockfileBaseTokens.NUM_LENGTH_BYTES + 1 + valueBytes.length;
        return new BlockfileIndexTokens(input.indexBlockId(), length, valueBytes);
    }

    private static byte[] encodeRowRange(BlockfileRowRange rowRange) {
        byte[] firstBytes = rowRange.first().copyOfBytes();
        byte[] lastBytes = rowRange.last().copyOfBytes();
        return ByteTool.concat(VarIntTool.encode(firstBytes.length), firstBytes, VarIntTool.encode(lastBytes.length), lastBytes);
    }

    @Override
    public BlockfileIndexBlock decode(byte[] bytes) {
        int cursor = BlockfileBaseTokens.NUM_LENGTH_BYTES + 1;
        long globalBlockId = VarIntTool.decodeLong(bytes, cursor);
        long indexBlockId = VarIntTool.decodeLong(bytes, cursor += VarIntTool.length(globalBlockId));
        int level = VarIntTool.decodeInt(bytes, cursor += VarIntTool.length(indexBlockId));
        int numChildren = VarIntTool.decodeInt(bytes, cursor += VarIntTool.length(level));
        int offsetsTableLength = numChildren * BlockfileIndexOffsetsTableRow.ROW_LENGTH;
        byte[] offsetsTable = Arrays.copyOfRange(bytes, cursor += VarIntTool.length(numChildren), cursor + offsetsTableLength);
        byte[] indexRecords = Arrays.copyOfRange(bytes, cursor += offsetsTableLength, bytes.length);
        return new BlockfileIndexBlock(globalBlockId, indexBlockId, level, numChildren, offsetsTable, indexRecords);
    }

    @Override
    public BlockfileIndexEntry decodeChild(BlockfileIndexBlock indexBlock, int childIndex) {
        BlockfileIndexOffsetsTableRow offsets = BlockfileV1IndexBlockCodec.decodeOffsets(indexBlock.offsetsTable(), childIndex);
        byte[] keysBytes = indexBlock.indexKeys();
        int cursor = offsets.indexOffset();
        int firstLength = VarIntTool.decodeInt(keysBytes, cursor);
        byte[] first = Arrays.copyOfRange(keysBytes, cursor += VarIntTool.length(firstLength), cursor + firstLength);
        int lastLength = VarIntTool.decodeInt(keysBytes, cursor += first.length);
        byte[] last = Arrays.copyOfRange(keysBytes, cursor += VarIntTool.length(lastLength), cursor + lastLength);
        cursor += last.length;
        return new BlockfileIndexEntry(indexBlock.level(), offsets.globalBlockId(), offsets.indexOrValueBlockId(), new BlockfileValueBlockIdRange(offsets.firstValueBlockId(), offsets.lastValueBlockId()), new BlockfileRowIdRange(offsets.firstRowId(), offsets.lastRowId()), new BlockfileRowRange(BlockfileRowVersionCodec.fromBytes(first), BlockfileRowVersionCodec.fromBytes(last)), new BlockfileByteRange(offsets.bytesFrom(), offsets.bytesTo()));
    }

    private static BlockfileIndexOffsetsTableRow decodeOffsets(byte[] offsetsTable, int index) {
        int offset = index * BlockfileIndexOffsetsTableRow.ROW_LENGTH;
        return BlockfileIndexOffsetsTableRow.decode(offsetsTable, offset);
    }

    private record BlockfileIndexOffsetsTableRow(long globalBlockId, long indexOrValueBlockId, long firstValueBlockId, long lastValueBlockId, long firstRowId, long lastRowId, long bytesFrom, int bytesLength, int indexOffset) {
        private static final int ROW_LENGTH = 7 * RawLongCodec.INSTANCE.length() + 2 * RawIntCodec.INSTANCE.length();

        public long bytesTo() {
            return this.bytesFrom + (long)this.bytesLength;
        }

        public byte[] encode() {
            return ByteTool.concat(RawLongCodec.INSTANCE.encode(this.globalBlockId), RawLongCodec.INSTANCE.encode(this.indexOrValueBlockId), RawLongCodec.INSTANCE.encode(this.firstValueBlockId), RawLongCodec.INSTANCE.encode(this.lastValueBlockId), RawLongCodec.INSTANCE.encode(this.firstRowId), RawLongCodec.INSTANCE.encode(this.lastRowId), RawLongCodec.INSTANCE.encode(this.bytesFrom), RawIntCodec.INSTANCE.encode(this.bytesLength), RawIntCodec.INSTANCE.encode(this.indexOffset));
        }

        public static BlockfileIndexOffsetsTableRow decode(byte[] bytes, int offset) {
            int cursor = offset;
            long globalBlockId = RawLongCodec.INSTANCE.decode(bytes, cursor);
            long indexOrValueBlockId = RawLongCodec.INSTANCE.decode(bytes, cursor += RawLongCodec.INSTANCE.length());
            long firstValueBlockId = RawLongCodec.INSTANCE.decode(bytes, cursor += RawLongCodec.INSTANCE.length());
            long lastValueBlockId = RawLongCodec.INSTANCE.decode(bytes, cursor += RawLongCodec.INSTANCE.length());
            long firstRowId = RawLongCodec.INSTANCE.decode(bytes, cursor += RawLongCodec.INSTANCE.length());
            long lastRowId = RawLongCodec.INSTANCE.decode(bytes, cursor += RawLongCodec.INSTANCE.length());
            long bytesFrom = RawLongCodec.INSTANCE.decode(bytes, cursor += RawLongCodec.INSTANCE.length());
            int bytesLength = RawIntCodec.INSTANCE.decode(bytes, cursor += RawLongCodec.INSTANCE.length());
            int indexOffset = RawIntCodec.INSTANCE.decode(bytes, cursor += RawIntCodec.INSTANCE.length());
            cursor += RawIntCodec.INSTANCE.length();
            return new BlockfileIndexOffsetsTableRow(globalBlockId, indexOrValueBlockId, firstValueBlockId, lastValueBlockId, firstRowId, lastRowId, bytesFrom, bytesLength, indexOffset);
        }
    }
}

