/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.encoding.checksum;

import io.datarouter.bytes.blockfile.encoding.checksum.BlockfileChecksummer;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BlockfileChecksummers {
    public final List<BlockfileChecksummer> all;

    public BlockfileChecksummers(List<BlockfileChecksummer> all) {
        this.all = new ArrayList<BlockfileChecksummer>(all);
    }

    public BlockfileChecksummers add(BlockfileChecksummer checksummer) {
        this.all.add(checksummer);
        return this;
    }

    public BlockfileChecksummer getForEncodedName(String encodedName) {
        return (BlockfileChecksummer)Scanner.of(this.all).include(checksummer -> checksummer.encodedName().equals(encodedName)).findFirst().orElseThrow(() -> {
            String registeredNames = this.all.stream().map(BlockfileChecksummer::encodedName).collect(Collectors.joining(",", "[", "]"));
            String message = String.format("checksummer with name=%s is not registered.  registeredChecksummers=%s", encodedName, registeredNames);
            throw new IllegalArgumentException(message);
        });
    }
}

