/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.block.tokens;

import io.datarouter.bytes.blockfile.block.BlockfileBlockType;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileBaseTokens;
import io.datarouter.bytes.blockfile.index.BlockfileRowIdRange;
import io.datarouter.bytes.blockfile.index.BlockfileRowRange;
import io.datarouter.bytes.blockfile.row.BlockfileRow;
import java.util.List;

public class BlockfileValueTokens
extends BlockfileBaseTokens {
    private final long valueBlockId;
    private final long firstRowId;
    private final List<BlockfileRow> rows;
    private final byte[] checksum;
    private final byte[] value;

    public BlockfileValueTokens(long valueBlockId, long firstRowId, List<BlockfileRow> rows, int length, byte[] checksum, byte[] value) {
        super(length, BlockfileBlockType.VALUE);
        this.valueBlockId = valueBlockId;
        this.firstRowId = firstRowId;
        this.rows = rows;
        this.checksum = checksum;
        this.value = value;
    }

    @Override
    public int suffixLength() {
        return this.checksum.length + this.value.length;
    }

    @Override
    public List<byte[]> toList() {
        return List.of(this.prefixBytes(), this.checksum, this.value);
    }

    public static int lengthWithoutValue(int checksumLength) {
        return BlockfileBaseTokens.NUM_PREFIX_BYTES + checksumLength;
    }

    public long valueBlockId() {
        return this.valueBlockId;
    }

    public BlockfileRowIdRange toRowIdRange() {
        return new BlockfileRowIdRange(this.firstRowId, this.firstRowId + (long)this.rows.size() - 1L);
    }

    public BlockfileRowRange toRowKeyRange() {
        return new BlockfileRowRange(this.rows.getFirst().toRowVersion(), this.rows.getLast().toRowVersion());
    }

    public List<BlockfileRow> rows() {
        return this.rows;
    }
}

