/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.block.tokens;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.blockfile.block.BlockfileBlockType;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import io.datarouter.scanner.Scanner;
import java.util.List;

public abstract class BlockfileBaseTokens {
    private static final RawIntCodec LENGTH_CODEC = RawIntCodec.INSTANCE;
    public static final int NUM_LENGTH_BYTES = LENGTH_CODEC.length();
    public static final int NUM_PREFIX_BYTES = NUM_LENGTH_BYTES + 1;
    private final int length;
    private final BlockfileBlockType blockType;

    public BlockfileBaseTokens(int length, BlockfileBlockType blockType) {
        this.length = length;
        this.blockType = blockType;
    }

    public int length() {
        return this.length;
    }

    public BlockfileBlockType blockType() {
        return this.blockType;
    }

    public byte[] encodeLength() {
        return LENGTH_CODEC.encode(this.length);
    }

    public static int decodeLength(byte[] lengthBytes) {
        return LENGTH_CODEC.decode(lengthBytes);
    }

    public byte[] encodeBlockType() {
        return this.blockType.codeBytes;
    }

    public byte[] prefixBytes() {
        return ByteTool.concat(this.encodeLength(), this.encodeBlockType());
    }

    public abstract int suffixLength();

    public int totalLength() {
        return NUM_PREFIX_BYTES + this.suffixLength();
    }

    public abstract List<byte[]> toList();

    public Scanner<byte[]> scan() {
        return Scanner.of(this.toList());
    }

    public byte[] concat() {
        return ByteTool.concat(this.toList());
    }
}

