/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.block.decoded;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.blockfile.block.BlockfileHeaderKey;
import io.datarouter.bytes.blockfile.encoding.checksum.BlockfileChecksummer;
import io.datarouter.bytes.blockfile.encoding.checksum.BlockfileChecksummers;
import io.datarouter.bytes.blockfile.encoding.compression.BlockfileCompressor;
import io.datarouter.bytes.blockfile.encoding.compression.BlockfileCompressors;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockFormat;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockFormats;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockFormat;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockFormats;

public record BlockfileHeaderBlock(BinaryDictionary userDictionary, BlockfileValueBlockFormat valueBlockFormat, BlockfileIndexBlockFormat indexBlockFormat, BlockfileCompressor compressor, BlockfileChecksummer checksummer) {
    private BinaryDictionary toBinaryDictionary() {
        return new BinaryDictionary().put(BlockfileHeaderKey.USER_DICTIONARY.bytes, this.userDictionary.encode()).put(BlockfileHeaderKey.VALUE_BLOCK_FORMAT.bytes, this.valueBlockFormat.nameToBytes()).put(BlockfileHeaderKey.INDEX_BLOCK_FORMAT.bytes, this.indexBlockFormat.nameToBytes()).put(BlockfileHeaderKey.COMPRESSOR.bytes, this.compressor.nameToBytes()).put(BlockfileHeaderKey.CHECKSUM_ALGORITHM.bytes, this.checksummer.nameToBytes());
    }

    public static class BlockfileHeaderCodec
    implements Codec<BlockfileHeaderBlock, byte[]> {
        private final BlockfileValueBlockFormats registeredValueBlockFormats;
        private final BlockfileIndexBlockFormats registeredIndexBlockFormats;
        private final BlockfileCompressors registeredCompressors;
        private final BlockfileChecksummers registeredChecksummers;

        public BlockfileHeaderCodec(BlockfileValueBlockFormats registeredValueBlockFormats, BlockfileIndexBlockFormats registeredIndexBlockFormats, BlockfileCompressors registeredCompressors, BlockfileChecksummers registeredChecksummers) {
            this.registeredValueBlockFormats = registeredValueBlockFormats;
            this.registeredIndexBlockFormats = registeredIndexBlockFormats;
            this.registeredCompressors = registeredCompressors;
            this.registeredChecksummers = registeredChecksummers;
        }

        @Override
        public byte[] encode(BlockfileHeaderBlock value) {
            return value.toBinaryDictionary().encode();
        }

        @Override
        public BlockfileHeaderBlock decode(byte[] valueBytes) {
            BinaryDictionary dictionary = BinaryDictionary.decode(valueBytes);
            return new BlockfileHeaderBlock(this.parseUserDictionary(dictionary), this.parseValueBlockFormat(dictionary), this.parseIndexBlockFormat(dictionary), this.parseCompressor(dictionary), this.parseChecksummer(dictionary));
        }

        private BinaryDictionary parseUserDictionary(BinaryDictionary dictionary) {
            byte[] userDictionaryBytes = dictionary.get(BlockfileHeaderKey.USER_DICTIONARY.bytes);
            return BinaryDictionary.decode(userDictionaryBytes);
        }

        private BlockfileValueBlockFormat parseValueBlockFormat(BinaryDictionary dictionary) {
            byte[] blockFormatNameBytes = dictionary.get(BlockfileHeaderKey.VALUE_BLOCK_FORMAT.bytes);
            String blockFormatName = BlockfileValueBlockFormat.bytesToName(blockFormatNameBytes);
            return this.registeredValueBlockFormats.getForEncodedName(blockFormatName);
        }

        private BlockfileIndexBlockFormat parseIndexBlockFormat(BinaryDictionary dictionary) {
            byte[] blockFormatNameBytes = dictionary.get(BlockfileHeaderKey.INDEX_BLOCK_FORMAT.bytes);
            String blockFormatName = BlockfileIndexBlockFormat.bytesToName(blockFormatNameBytes);
            return this.registeredIndexBlockFormats.getForEncodedName(blockFormatName);
        }

        private BlockfileCompressor parseCompressor(BinaryDictionary dictionary) {
            byte[] compressorNameBytes = dictionary.get(BlockfileHeaderKey.COMPRESSOR.bytes);
            String compressorName = BlockfileCompressor.bytesToName(compressorNameBytes);
            return this.registeredCompressors.getForEncodedName(compressorName);
        }

        private BlockfileChecksummer parseChecksummer(BinaryDictionary dictionary) {
            byte[] checksummerNameBytes = dictionary.get(BlockfileHeaderKey.CHECKSUM_ALGORITHM.bytes);
            String checksummerName = BlockfileChecksummer.bytesToName(checksummerNameBytes);
            return this.registeredChecksummers.getForEncodedName(checksummerName);
        }
    }
}

