/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.block.common;

import io.datarouter.bytes.blockfile.block.BlockfileBlockType;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import io.datarouter.bytes.io.InputStreamTool;
import java.io.InputStream;

public record BlockfileBlockHeader(int length, BlockfileBlockType blockType) {
    public static final int LENGTH = 5;

    public int fullBlockLength() {
        return 5 + this.length;
    }

    public int encode(byte[] bytes, int offset) {
        int cursor = offset;
        cursor += RawIntCodec.INSTANCE.encode(this.length, bytes, cursor);
        bytes[cursor] = this.blockType.codeByte;
        ++cursor;
        return 5;
    }

    public void encode(byte[] bytes) {
        this.encode(bytes, 0);
    }

    public byte[] encode() {
        byte[] bytes = new byte[5];
        this.encode(bytes);
        return bytes;
    }

    public static BlockfileBlockHeader decode(byte[] bytes, int offset) {
        int cursor = offset;
        int length = RawIntCodec.INSTANCE.decode(bytes, offset);
        BlockfileBlockType blockType = BlockfileBlockType.decode(bytes[cursor += RawIntCodec.INSTANCE.length()]);
        ++cursor;
        return new BlockfileBlockHeader(length, blockType);
    }

    public static BlockfileBlockHeader decode(byte[] bytes) {
        return BlockfileBlockHeader.decode(bytes, 0);
    }

    public static BlockfileBlockHeader decode(InputStream inputStream) {
        byte[] bytes = InputStreamTool.readNBytes(inputStream, 5);
        return BlockfileBlockHeader.decode(bytes);
    }
}

