/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile;

import io.datarouter.bytes.blockfile.BlockfileGroup;
import io.datarouter.bytes.blockfile.encoding.checksum.BlockfileChecksummer;
import io.datarouter.bytes.blockfile.encoding.checksum.BlockfileChecksummers;
import io.datarouter.bytes.blockfile.encoding.checksum.BlockfileStandardChecksummers;
import io.datarouter.bytes.blockfile.encoding.compression.BlockfileCompressor;
import io.datarouter.bytes.blockfile.encoding.compression.BlockfileCompressors;
import io.datarouter.bytes.blockfile.encoding.compression.BlockfileStandardCompressors;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockFormat;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockFormats;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileStandardIndexBlockFormats;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileStandardValueBlockFormats;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockFormat;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockFormats;
import io.datarouter.bytes.blockfile.io.storage.BlockfileStorage;

public class BlockfileGroupBuilder<T> {
    private final BlockfileStorage storage;
    private final BlockfileValueBlockFormats registeredValueBlockFormats = new BlockfileValueBlockFormats(BlockfileStandardValueBlockFormats.ALL);
    private final BlockfileIndexBlockFormats registeredIndexBlockFormats = new BlockfileIndexBlockFormats(BlockfileStandardIndexBlockFormats.ALL);
    private final BlockfileCompressors registeredCompressors = new BlockfileCompressors(BlockfileStandardCompressors.ALL);
    private final BlockfileChecksummers registeredChecksummers = new BlockfileChecksummers(BlockfileStandardChecksummers.ALL);

    public BlockfileGroupBuilder(BlockfileStorage storage) {
        this.storage = storage;
    }

    public BlockfileGroupBuilder<T> registerBlockFormat(BlockfileValueBlockFormat format) {
        this.registeredValueBlockFormats.add(format);
        return this;
    }

    public BlockfileGroupBuilder<T> registerIndexBlockFormat(BlockfileIndexBlockFormat format) {
        this.registeredIndexBlockFormats.add(format);
        return this;
    }

    public BlockfileGroupBuilder<T> registerCompressor(BlockfileCompressor compressor) {
        this.registeredCompressors.add(compressor);
        return this;
    }

    public BlockfileGroupBuilder<T> registerChecksummer(BlockfileChecksummer checksummer) {
        this.registeredChecksummers.add(checksummer);
        return this;
    }

    public BlockfileGroup<T> build() {
        return new BlockfileGroup(this.storage, this.registeredValueBlockFormats, this.registeredIndexBlockFormats, this.registeredCompressors, this.registeredChecksummers);
    }
}

