/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.split;

import io.datarouter.scanner.Scanner;

public class ChunkScannerTool {
    public static Scanner<ChunkRange> scanChunks(long fromInclusive, long toExclusive, int chunkSize) {
        long totalLength = toExclusive - fromInclusive;
        int initialLength = (int)Math.min((long)chunkSize, totalLength);
        ChunkRange intialRange = new ChunkRange(fromInclusive, initialLength);
        return Scanner.iterate((Object)intialRange, previous -> {
            long start = previous.start + (long)previous.length;
            long remainingBytes = toExclusive - start;
            int length = (int)Math.min((long)chunkSize, remainingBytes);
            return new ChunkRange(start, length);
        }).advanceWhile(range -> range.length > 0);
    }

    public static class ChunkRange {
        public final long start;
        public final int length;

        public ChunkRange(long start, int length) {
            this.start = start;
            this.length = length;
        }

        public String toString() {
            return String.format("start=%s, length=%s", this.start, this.length);
        }
    }
}

