/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.split;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.split.ByteChunkSplitterCollector;
import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.Threads;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class ByteChunkSplitter<T> {
    private final Supplier<ByteChunkSplitterCollector<T>> collectorSupplier;

    public ByteChunkSplitter(Supplier<ByteChunkSplitterCollector<T>> collectorSupplier) {
        this.collectorSupplier = collectorSupplier;
    }

    public Scanner<List<T>> split(Scanner<byte[]> byteArrays, Threads threads, byte delimiter, boolean skipFirst) {
        AtomicBoolean remainingSkipFirst = new AtomicBoolean(skipFirst);
        return byteArrays.parallelOrdered(threads).map(chunk -> ByteChunkSplitter.split(chunk, delimiter, remainingSkipFirst.getAndSet(false), this.collectorSupplier.get())).link(chunkTokensScanner -> new ByteChunkParsingScanner<T>(chunkTokensScanner, this.collectorSupplier.get()));
    }

    public static <T> ParsedByteChunk<T> split(byte[] chunk, byte delimiter, boolean skipFirst, ByteChunkSplitterCollector<T> collector) {
        boolean pendingSkip = skipFirst;
        byte[] first = null;
        int count = 0;
        int start = 0;
        int i = 0;
        while (i < chunk.length) {
            if (chunk[i] == delimiter) {
                if (pendingSkip && count == 0) {
                    pendingSkip = false;
                } else {
                    int len = i - start + 1;
                    if (count == 0) {
                        first = Arrays.copyOfRange(chunk, start, start + len);
                    } else {
                        collector.collect(chunk, start, len);
                    }
                    ++count;
                }
                start = i + 1;
            }
            ++i;
        }
        int lastTokenLength = chunk.length - start;
        byte[] last = null;
        if (lastTokenLength > 0) {
            byte[] lastToken = Arrays.copyOfRange(chunk, start, start + lastTokenLength);
            if (lastToken[lastToken.length - 1] == delimiter) {
                collector.collect(lastToken, start, lastTokenLength);
            } else {
                last = lastToken;
            }
        }
        if (pendingSkip && count == 0) {
            throw new RuntimeException("Couldn't skip first token as delimiter not found in first chunk.");
        }
        return new ParsedByteChunk<T>(first, collector.toList(), last);
    }

    public static class ByteChunkParsingScanner<T>
    extends BaseLinkedScanner<ParsedByteChunk<T>, List<T>> {
        private final ByteChunkSplitterCollector<T> collector;
        private final PendingChunk<T> pending;
        private byte[] carryover;

        public ByteChunkParsingScanner(Scanner<ParsedByteChunk<T>> chunks, ByteChunkSplitterCollector<T> collector) {
            super(chunks);
            this.collector = collector;
            this.pending = new PendingChunk();
            this.carryover = null;
        }

        public boolean advanceInternal() {
            while (true) {
                if (this.carryover != null) {
                    if (this.pending.hasFirst()) {
                        this.carryover = ByteTool.concat(this.carryover, this.pending.takeFirst());
                        T mappedCarryover = this.collector.encode(this.carryover, 0, this.carryover.length);
                        this.current = Collections.singletonList(mappedCarryover);
                        this.carryover = null;
                        return true;
                    }
                    if (this.pending.hasLast()) {
                        this.carryover = ByteTool.concat(this.carryover, this.pending.takeLast());
                    }
                }
                if (this.pending.hasFirst()) {
                    byte[] first = this.pending.takeFirst();
                    T mappedFirst = this.collector.encode(first, 0, first.length);
                    this.current = Collections.singletonList(mappedFirst);
                    return true;
                }
                if (this.pending.hasMiddle()) {
                    this.current = this.pending.takeMiddle();
                    return true;
                }
                if (this.pending.hasLast()) {
                    this.carryover = this.pending.takeLast();
                }
                if (!this.input.advance()) break;
                this.pending.reload((ParsedByteChunk)this.input.current());
            }
            if (this.carryover != null) {
                T mappedCarryover = this.collector.encode(this.carryover, 0, this.carryover.length);
                this.current = Collections.singletonList(mappedCarryover);
                this.carryover = null;
                return true;
            }
            return false;
        }
    }

    public static class ParsedByteChunk<T> {
        public final byte[] first;
        public final List<T> middle;
        public final byte[] last;

        public ParsedByteChunk(byte[] first, List<T> middle, byte[] last) {
            if (first == null && middle.isEmpty() && last == null) {
                throw new IllegalArgumentException("no data");
            }
            this.first = first;
            this.middle = middle;
            this.last = last;
        }

        public int totalTokens() {
            int total = 0;
            if (this.first != null) {
                ++total;
            }
            total += this.middle.size();
            if (this.last != null) {
                ++total;
            }
            return total;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.first != null) {
                sb.append("f" + Arrays.toString(this.first));
            }
            this.middle.forEach(token -> {
                StringBuilder stringBuilder2 = sb.append("m" + String.valueOf(token));
            });
            if (this.last != null) {
                sb.append("l" + Arrays.toString(this.last));
            }
            return sb.toString();
        }
    }

    private static class PendingChunk<T> {
        byte[] first;
        List<T> middle;
        byte[] last;

        private PendingChunk() {
        }

        void reload(ParsedByteChunk<T> tokens) {
            if (this.hasFirst()) {
                throw new IllegalStateException("first still exists");
            }
            if (this.hasMiddle()) {
                throw new IllegalStateException("middle still exists");
            }
            if (this.hasLast()) {
                throw new IllegalStateException("last still exists");
            }
            this.first = tokens.first;
            this.middle = tokens.middle.isEmpty() ? null : tokens.middle;
            this.last = tokens.last;
        }

        boolean hasFirst() {
            return this.first != null;
        }

        boolean hasMiddle() {
            return this.middle != null;
        }

        boolean hasLast() {
            return this.last != null;
        }

        byte[] takeFirst() {
            if (this.first == null) {
                throw new IllegalStateException("first is missing");
            }
            byte[] result = this.first;
            this.first = null;
            return result;
        }

        List<T> takeMiddle() {
            if (this.middle == null) {
                throw new IllegalStateException("middle is missing");
            }
            List<T> result = this.middle;
            this.middle = null;
            return result;
        }

        byte[] takeLast() {
            if (this.last == null) {
                throw new IllegalStateException("last is missing");
            }
            byte[] result = this.last;
            this.last = null;
            return result;
        }
    }
}

