/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.merge;

import io.datarouter.bytes.blockfile.dto.BlockfileNameAndSize;
import io.datarouter.bytes.kvfile.merge.KvFileMergePlan;
import io.datarouter.bytes.kvfile.merge.KvFileMergerParams;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public class KvFileMergerThreadsCalculator {
    private final KvFileMergePlan plan;
    private final KvFileMergerParams.Nested.KvFileMergerReadParams readParams;

    public KvFileMergerThreadsCalculator(KvFileMergePlan plan, KvFileMergerParams.Nested.KvFileMergerReadParams readParams) {
        this.plan = plan;
        this.readParams = readParams;
    }

    public List<ThreadsForFile> calc() {
        long bufferSize = this.readParams.readBufferSize().toBytes();
        long chunkSize = this.readParams.readChunkSize().toBytes();
        int maxThreads = Double.valueOf(bufferSize / chunkSize).intValue();
        AtomicInteger remainingFiles = new AtomicInteger(this.plan.files().size());
        AtomicLong remainingBytes = new AtomicLong(this.plan.totalInputSize().toBytes());
        AtomicInteger remainingThreads = new AtomicInteger(maxThreads);
        Predicate<BlockfileNameAndSize> isSmallFilePredicate = file -> file.size() <= chunkSize;
        ArrayList result = new ArrayList();
        Scanner.of(this.plan.files()).include(isSmallFilePredicate).forEach(file -> {
            remainingFiles.decrementAndGet();
            remainingBytes.addAndGet(-file.size());
            result.add(new ThreadsForFile((BlockfileNameAndSize)file, 1));
        });
        long fixedRemainingBytes = remainingBytes.get();
        Scanner.of(this.plan.files()).exclude(isSmallFilePredicate).sort(Comparator.comparing(BlockfileNameAndSize::size).reversed()).forEach(file -> {
            int numThreads;
            if (remainingFiles.get() > 1) {
                double pctOfTotalSize = (double)file.size() / (double)fixedRemainingBytes;
                double numThreadsCalc = pctOfTotalSize * (double)maxThreads;
                numThreads = Math.max(1, (int)numThreadsCalc);
            } else {
                numThreads = Math.max(1, remainingThreads.get());
            }
            remainingFiles.decrementAndGet();
            remainingBytes.addAndGet(-file.size());
            remainingThreads.addAndGet(-numThreads);
            result.add(new ThreadsForFile((BlockfileNameAndSize)file, numThreads));
        });
        return Scanner.of(result).sort(Comparator.comparing(ThreadsForFile::threads).reversed()).list();
    }

    public record ThreadsForFile(BlockfileNameAndSize file, int threads) {
    }
}

