/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.kv;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.bytestringcodec.HexByteStringCodec;
import io.datarouter.bytes.codec.longcodec.ComparableLongCodec;
import io.datarouter.bytes.kvfile.kv.KvFileEntryCodec;
import io.datarouter.bytes.kvfile.kv.KvFileOp;
import java.util.Arrays;
import java.util.Objects;

public class KvFileEntry {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private final int keyOffset;
    private final int keyLength;
    private final int versionOffset;
    private final int versionLength;
    private final KvFileOp op;
    private final int valueOffset;
    private final int valueLength;

    public KvFileEntry(byte[] bytes, int offset, int length, int keyOffset, int keyLength, int versionOffset, int versionLength, KvFileOp op, int valueOffset, int valueLength) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(op);
        if (op == KvFileOp.DELETE && valueLength != 0) {
            throw new IllegalArgumentException("Cannot have value with delete op");
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.keyOffset = keyOffset;
        this.keyLength = keyLength;
        this.versionOffset = versionOffset;
        this.versionLength = versionLength;
        this.op = op;
        this.valueOffset = valueOffset;
        this.valueLength = valueLength;
        if (length != valueOffset + valueLength - offset) {
            String message = String.format("length[%s] != valueOffset[%s]+valueLength[%s]", length, valueOffset, valueLength);
            throw new IllegalArgumentException(message);
        }
    }

    public static KvFileEntry create(byte[] key, byte[] version, KvFileOp op, byte[] value) {
        byte[] bytes = KvFileEntryCodec.toBytes(key, version, op, value);
        return KvFileEntryCodec.fromBytes(bytes);
    }

    public static KvFileEntry putWithoutVersion(byte[] key, byte[] value) {
        return KvFileEntry.create(key, EmptyArray.BYTE, KvFileOp.PUT, value);
    }

    public static KvFileEntry putWithLongVersion(byte[] key, long version, byte[] value) {
        return KvFileEntry.create(key, ComparableLongCodec.INSTANCE.encode(version), KvFileOp.PUT, value);
    }

    public static boolean equalsKeyOptimized(KvFileEntry left, KvFileEntry right) {
        if (left.keyLength != right.keyLength) {
            return false;
        }
        if (left.keyLength == 0) {
            return true;
        }
        int leftTo = left.keyOffset + left.keyLength;
        int rightTo = right.keyOffset + right.keyLength;
        if (left.bytes[leftTo - 1] != right.bytes[rightTo - 1]) {
            return false;
        }
        return Arrays.equals(left.bytes, left.keyOffset, leftTo, right.bytes, right.keyOffset, rightTo);
    }

    public static boolean equalsVersion(KvFileEntry left, KvFileEntry right) {
        int leftTo = left.versionOffset + left.versionLength;
        int rightTo = right.versionOffset + right.versionLength;
        return Arrays.equals(left.bytes, left.versionOffset, leftTo, right.bytes, right.versionOffset, rightTo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KvFileEntry other = (KvFileEntry)obj;
        return Arrays.equals(this.bytes, this.offset, this.offset + this.length, other.bytes, other.offset, other.offset + other.length);
    }

    public int hashCode() {
        int result = 1;
        int i = this.offset;
        while (i < this.length) {
            result = 31 * result + this.bytes[i];
            ++i;
        }
        return result;
    }

    public static int compareKey(KvFileEntry left, KvFileEntry right) {
        return Arrays.compareUnsigned(left.bytes, left.keyOffset, left.keyOffset + left.keyLength, right.bytes, right.keyOffset, right.keyOffset + right.keyLength);
    }

    public static int compareVersion(KvFileEntry left, KvFileEntry right) {
        return Arrays.compareUnsigned(left.bytes, left.versionOffset, left.versionOffset + left.versionLength, right.bytes, right.versionOffset, right.versionOffset + right.versionLength);
    }

    public static int compareKeyVersionOpOptimized(KvFileEntry left, KvFileEntry right) {
        int keyDiff = KvFileEntry.compareKey(left, right);
        if (keyDiff != 0) {
            return keyDiff;
        }
        int versionDiff = KvFileEntry.compareVersion(left, right);
        if (versionDiff != 0) {
            return versionDiff;
        }
        return left.op.compareTo(right.op);
    }

    public byte[] backingBytes() {
        return this.bytes;
    }

    public byte[] copyOfBytes() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public int keyOffset() {
        return this.keyOffset;
    }

    public int keyLength() {
        return this.keyLength;
    }

    public byte[] copyOfKey() {
        return Arrays.copyOfRange(this.bytes, this.keyOffset, this.keyOffset + this.keyLength);
    }

    public int versionOffset() {
        return this.versionOffset;
    }

    public int versionLength() {
        return this.versionLength;
    }

    public byte[] copyOfVersion() {
        return Arrays.copyOfRange(this.bytes, this.versionOffset, this.versionOffset + this.versionLength);
    }

    public KvFileOp op() {
        return this.op;
    }

    public int valueOffset() {
        return this.valueOffset;
    }

    public int valueLength() {
        return this.valueLength;
    }

    public byte[] copyOfValue() {
        return Arrays.copyOfRange(this.bytes, this.valueOffset, this.valueOffset + this.valueLength);
    }

    public String toString() {
        return HexByteStringCodec.INSTANCE.encode(this.copyOfBytes());
    }
}

